/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;

class LongAdderModule
extends SimpleModule {
    LongAdderModule() {
        this.addSerializer(LongAdder.class, new LongAdderSerializer());
        this.addDeserializer(LongAdder.class, new LongAdderDeserializer());
    }

    private static class LongAdderSerializer
    extends JsonSerializer<LongAdder> {
        private LongAdderSerializer() {
        }

        public void serialize(LongAdder value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeNumber(value.longValue());
        }
    }

    private static class LongAdderDeserializer
    extends JsonDeserializer<LongAdder> {
        private LongAdderDeserializer() {
        }

        public LongAdder deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            LongAdder result = new LongAdder();
            result.add(parser.getLongValue());
            return result;
        }
    }
}

