/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler.openrtb2;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.prebid.server.analytics.model.VideoEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.ExchangeService;
import org.prebid.server.auction.VideoResponseFactory;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.auction.model.WithPodErrors;
import org.prebid.server.auction.requestfactory.VideoRequestFactory;
import org.prebid.server.cache.CacheService;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.UnauthorizedAccountException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.proto.response.VideoResponse;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.version.PrebidVersionProvider;

public class VideoHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(VideoHandler.class);
    private static final MetricName REQUEST_TYPE_METRIC = MetricName.video;
    private final VideoRequestFactory videoRequestFactory;
    private final VideoResponseFactory videoResponseFactory;
    private final ExchangeService exchangeService;
    private final CacheService cacheService;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final Metrics metrics;
    private final Clock clock;
    private final PrebidVersionProvider prebidVersionProvider;
    private final JacksonMapper mapper;

    public VideoHandler(VideoRequestFactory videoRequestFactory, VideoResponseFactory videoResponseFactory, ExchangeService exchangeService, CacheService cacheService, AnalyticsReporterDelegator analyticsDelegator, Metrics metrics, Clock clock, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        this.videoRequestFactory = Objects.requireNonNull(videoRequestFactory);
        this.videoResponseFactory = Objects.requireNonNull(videoResponseFactory);
        this.exchangeService = Objects.requireNonNull(exchangeService);
        this.cacheService = Objects.requireNonNull(cacheService);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        long startTime = this.clock.millis();
        VideoEvent.VideoEventBuilder videoEventBuilder = VideoEvent.builder().httpContext(HttpRequestContext.from(routingContext));
        this.videoRequestFactory.fromRequest(routingContext, startTime).map(contextToErrors -> VideoHandler.addToEvent(contextToErrors.getData(), videoEventBuilder::auctionContext, contextToErrors)).compose(contextToErrors -> this.exchangeService.holdAuction((AuctionContext)contextToErrors.getData()).map(context -> WithPodErrors.of(context, contextToErrors.getPodErrors()))).map(contextToErrors -> VideoHandler.addToEvent(contextToErrors.getData(), videoEventBuilder::auctionContext, contextToErrors)).map(result -> this.videoResponseFactory.toVideoResponse((AuctionContext)result.getData(), ((AuctionContext)result.getData()).getBidResponse(), result.getPodErrors())).map(videoResponse -> VideoHandler.addToEvent(videoResponse, videoEventBuilder::bidResponse, videoResponse)).onComplete(responseResult -> this.handleResult((AsyncResult<VideoResponse>)responseResult, videoEventBuilder, routingContext, startTime));
    }

    private static <T, R> R addToEvent(T field, Consumer<T> consumer, R result) {
        consumer.accept(field);
        return result;
    }

    private void handleResult(AsyncResult<VideoResponse> responseResult, VideoEvent.VideoEventBuilder videoEventBuilder, RoutingContext routingContext, long startTime) {
        String cacheKey;
        Object body;
        HttpResponseStatus status;
        List<Object> errorMessages;
        MetricName metricRequestStatus;
        boolean responseSucceeded = responseResult.succeeded();
        VideoResponse videoResponse = responseSucceeded ? (VideoResponse)responseResult.result() : null;
        HttpServerResponse response = routingContext.response();
        this.enrichWithCommonHeaders(response);
        if (responseSucceeded) {
            metricRequestStatus = MetricName.ok;
            errorMessages = Collections.emptyList();
            status = HttpResponseStatus.OK;
            this.enrichWithSuccessfulHeaders(response);
            body = this.mapper.encodeToString(videoResponse);
        } else {
            Throwable exception = responseResult.cause();
            if (exception instanceof InvalidRequestException) {
                metricRequestStatus = MetricName.badinput;
                errorMessages = ((InvalidRequestException)exception).getMessages();
                logger.info((Object)"Invalid request format: {0}", new Object[]{errorMessages});
                status = HttpResponseStatus.BAD_REQUEST;
                body = errorMessages.stream().map(msg -> "Invalid request format: " + msg).collect(Collectors.joining("\n"));
            } else if (exception instanceof UnauthorizedAccountException) {
                metricRequestStatus = MetricName.badinput;
                String errorMessage = exception.getMessage();
                logger.info((Object)"Unauthorized: {0}", new Object[]{errorMessage});
                errorMessages = Collections.singletonList(errorMessage);
                status = HttpResponseStatus.UNAUTHORIZED;
                body = "Unauthorised: " + errorMessage;
            } else {
                metricRequestStatus = MetricName.err;
                logger.error((Object)"Critical error while running the auction", exception);
                String message = exception.getMessage();
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                body = "Critical error while running the auction: " + message;
            }
        }
        VideoEvent videoEvent = videoEventBuilder.status(status.code()).errors(errorMessages).build();
        AuctionContext auctionContext = videoEvent.getAuctionContext();
        CachedDebugLog cachedDebugLog = auctionContext != null ? auctionContext.getCachedDebugLog() : null;
        String string = cacheKey = this.shouldCacheLog(status.code(), cachedDebugLog) ? this.cacheDebugLog(auctionContext, videoEvent.getErrors()) : null;
        if (status.code() != 200 && cacheKey != null) {
            videoEvent = this.updateEventWithDebugCacheMessage(videoEvent, cacheKey);
        }
        PrivacyContext privacyContext = auctionContext != null ? auctionContext.getPrivacyContext() : null;
        TcfContext tcfContext = privacyContext != null ? privacyContext.getTcfContext() : TcfContext.empty();
        this.respondWith(routingContext, status, (String)body, startTime, metricRequestStatus, videoEvent, tcfContext);
    }

    private boolean shouldCacheLog(int status, CachedDebugLog cachedDebugLog) {
        return cachedDebugLog != null && cachedDebugLog.isEnabled() && (status != 200 || !cachedDebugLog.hasBids());
    }

    private String cacheDebugLog(AuctionContext auctionContext, List<String> errors) {
        CachedDebugLog cachedDebugLog = auctionContext.getCachedDebugLog();
        cachedDebugLog.setErrors(errors);
        AccountAuctionConfig accountAuctionConfig = ObjectUtil.getIfNotNull(auctionContext.getAccount(), Account::getAuction);
        Integer videoCacheTtl = ObjectUtil.getIfNotNull(accountAuctionConfig, AccountAuctionConfig::getVideoCacheTtl);
        return this.cacheService.cacheVideoDebugLog(cachedDebugLog, videoCacheTtl);
    }

    private VideoEvent updateEventWithDebugCacheMessage(VideoEvent videoEvent, String cacheKey) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.add("[Debug cache ID: %s]".formatted(cacheKey));
        errors.addAll(videoEvent.getErrors());
        return videoEvent.toBuilder().errors(errors).build();
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body, long startTime, MetricName metricRequestStatus, VideoEvent event, TcfContext tcfContext) {
        boolean responseSent = HttpUtil.executeSafely(routingContext, Endpoint.openrtb2_video, response -> response.exceptionHandler(this::handleResponseException).setStatusCode(status.code()).end(body));
        if (responseSent) {
            this.metrics.updateRequestTimeMetric(REQUEST_TYPE_METRIC, this.clock.millis() - startTime);
            this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, metricRequestStatus);
            this.analyticsDelegator.processEvent(event, tcfContext);
        } else {
            this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, MetricName.networkerr);
        }
    }

    private void handleResponseException(Throwable throwable) {
        logger.warn((Object)"Failed to send video response: {0}", new Object[]{throwable.getMessage()});
        this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, MetricName.networkerr);
    }

    private void enrichWithCommonHeaders(HttpServerResponse response) {
        HttpUtil.addHeaderIfValueIsNotEmpty(response.headers(), HttpUtil.X_PREBID_HEADER, this.prebidVersionProvider.getNameVersionRecord());
    }

    private void enrichWithSuccessfulHeaders(HttpServerResponse response) {
        response.headers().add(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }
}

