/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

public class VersionHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(VersionHandler.class);
    private final String endpoint;
    private final String revisionResponseBody;

    public VersionHandler(String version, String commitHash, JacksonMapper mapper, String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint);
        this.revisionResponseBody = VersionHandler.createRevisionResponseBody(version, commitHash, mapper);
    }

    private static String createRevisionResponseBody(String version, String commitHash, JacksonMapper mapper) {
        try {
            return mapper.mapper().writeValueAsString((Object)RevisionResponse.of(commitHash, version));
        }
        catch (JsonProcessingException e) {
            logger.error((Object)"/version Critical error when trying to marshal revision response: %s", new Object[]{e.getMessage()});
            return null;
        }
    }

    public void handle(RoutingContext routingContext) {
        if (StringUtils.isNotBlank((CharSequence)this.revisionResponseBody)) {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.end(this.revisionResponseBody));
        } else {
            HttpUtil.executeSafely(routingContext, this.endpoint, response -> response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end());
        }
    }

    private static final class RevisionResponse {
        private final String revision;
        private final String version;

        public String getRevision() {
            return this.revision;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevisionResponse)) {
                return false;
            }
            RevisionResponse other = (RevisionResponse)o;
            String this$revision = this.getRevision();
            String other$revision = other.getRevision();
            if (this$revision == null ? other$revision != null : !this$revision.equals(other$revision)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $revision = this.getRevision();
            result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "VersionHandler.RevisionResponse(revision=" + this.getRevision() + ", version=" + this.getVersion() + ")";
        }

        @ConstructorProperties(value={"revision", "version"})
        private RevisionResponse(String revision, String version) {
            this.revision = revision;
            this.version = version;
        }

        public static RevisionResponse of(String revision, String version) {
            return new RevisionResponse(revision, version);
        }
    }
}

