/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.activity.infrastructure.payload.impl.ActivityInvocationPayloadImpl;
import org.prebid.server.activity.infrastructure.payload.impl.TcfContextActivityInvocationPayload;
import org.prebid.server.analytics.model.SetuidEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.gpp.SetuidGppService;
import org.prebid.server.auction.model.SetuidContext;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.UsersyncFormat;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncMethodType;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.cookie.exception.UnauthorizedUidsException;
import org.prebid.server.cookie.exception.UnavailableForLegalReasonsException;
import org.prebid.server.cookie.model.UidsCookieUpdateResult;
import org.prebid.server.exception.InvalidAccountConfigException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.Endpoint;
import org.prebid.server.privacy.HostVendorTcfDefinerService;
import org.prebid.server.privacy.gdpr.model.HostVendorTcfResponse;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.HttpUtil;

public class SetuidHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(SetuidHandler.class);
    private static final String BIDDER_PARAM = "bidder";
    private static final String UID_PARAM = "uid";
    private static final String PIXEL_FILE_PATH = "static/tracking-pixel.png";
    private static final String ACCOUNT_PARAM = "account";
    private static final int UNAVAILABLE_FOR_LEGAL_REASONS = 451;
    private final long defaultTimeout;
    private final UidsCookieService uidsCookieService;
    private final ApplicationSettings applicationSettings;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final SetuidGppService gppService;
    private final ActivityInfrastructureCreator activityInfrastructureCreator;
    private final HostVendorTcfDefinerService tcfDefinerService;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final Metrics metrics;
    private final TimeoutFactory timeoutFactory;
    private final Map<String, UsersyncMethodType> cookieNameToSyncType;

    public SetuidHandler(long defaultTimeout, UidsCookieService uidsCookieService, ApplicationSettings applicationSettings, BidderCatalog bidderCatalog, PrivacyEnforcementService privacyEnforcementService, SetuidGppService gppService, ActivityInfrastructureCreator activityInfrastructureCreator, HostVendorTcfDefinerService tcfDefinerService, AnalyticsReporterDelegator analyticsDelegator, Metrics metrics, TimeoutFactory timeoutFactory) {
        this.defaultTimeout = defaultTimeout;
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.gppService = Objects.requireNonNull(gppService);
        this.activityInfrastructureCreator = Objects.requireNonNull(activityInfrastructureCreator);
        this.tcfDefinerService = Objects.requireNonNull(tcfDefinerService);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.metrics = Objects.requireNonNull(metrics);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.cookieNameToSyncType = bidderCatalog.names().stream().filter(bidderCatalog::isActive).map(bidderCatalog::usersyncerByName).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toMap(Usersyncer::getCookieFamilyName, SetuidHandler::preferredUserSyncType));
    }

    private static UsersyncMethodType preferredUserSyncType(Usersyncer usersyncer) {
        return Stream.of(usersyncer.getIframe(), usersyncer.getRedirect()).filter(Objects::nonNull).findFirst().map(UsersyncMethod::getType).get();
    }

    public void handle(RoutingContext routingContext) {
        this.toSetuidContext(routingContext).onComplete(setuidContextResult -> this.handleSetuidContextResult((AsyncResult<SetuidContext>)setuidContextResult, routingContext));
    }

    private Future<SetuidContext> toSetuidContext(RoutingContext routingContext) {
        UidsCookie uidsCookie = this.uidsCookieService.parseFromRequest(routingContext);
        HttpServerRequest httpRequest = routingContext.request();
        String cookieName = httpRequest.getParam(BIDDER_PARAM);
        String requestAccount = httpRequest.getParam(ACCOUNT_PARAM);
        Timeout timeout = this.timeoutFactory.create(this.defaultTimeout);
        return this.accountById(requestAccount, timeout).compose(account -> this.privacyEnforcementService.contextFromSetuidRequest(httpRequest, (Account)account, timeout).map(privacyContext -> SetuidContext.builder().routingContext(routingContext).uidsCookie(uidsCookie).timeout(timeout).account((Account)account).cookieName(cookieName).syncType(this.cookieNameToSyncType.get(cookieName)).privacyContext((PrivacyContext)privacyContext).build())).compose(setuidContext -> this.gppService.contextFrom((SetuidContext)setuidContext).map(setuidContext::with)).map(this::fillWithActivityInfrastructure).map(this.gppService::updateSetuidContext);
    }

    private Future<Account> accountById(String accountId, Timeout timeout) {
        return StringUtils.isBlank((CharSequence)accountId) ? Future.succeededFuture((Object)Account.empty(accountId)) : this.applicationSettings.getAccountById(accountId, timeout).otherwise((Object)Account.empty(accountId));
    }

    private SetuidContext fillWithActivityInfrastructure(SetuidContext setuidContext) {
        return setuidContext.toBuilder().activityInfrastructure(this.activityInfrastructureCreator.create(setuidContext.getAccount(), setuidContext.getGppContext(), null)).build();
    }

    private void handleSetuidContextResult(AsyncResult<SetuidContext> setuidContextResult, RoutingContext routingContext) {
        if (setuidContextResult.succeeded()) {
            SetuidContext setuidContext = (SetuidContext)setuidContextResult.result();
            String bidder = setuidContext.getCookieName();
            TcfContext tcfContext = setuidContext.getPrivacyContext().getTcfContext();
            try {
                this.validateSetuidContext(setuidContext, bidder);
            }
            catch (UnauthorizedUidsException | UnavailableForLegalReasonsException | InvalidRequestException e) {
                this.handleErrors(e, routingContext, tcfContext);
                return;
            }
            this.isAllowedForHostVendorId(tcfContext).onComplete(hostTcfResponseResult -> this.respondByTcfResponse((AsyncResult<HostVendorTcfResponse>)hostTcfResponseResult, setuidContext));
        } else {
            Throwable error = setuidContextResult.cause();
            this.handleErrors(error, routingContext, null);
        }
    }

    private void validateSetuidContext(SetuidContext setuidContext, String bidder) {
        TcfContextActivityInvocationPayload activityInvocationPayload;
        String cookieName = setuidContext.getCookieName();
        boolean isCookieNameBlank = StringUtils.isBlank((CharSequence)cookieName);
        if (isCookieNameBlank || !this.cookieNameToSyncType.containsKey(cookieName)) {
            String cookieNameError = isCookieNameBlank ? "required" : "invalid";
            throw new InvalidRequestException("\"bidder\" query param is " + cookieNameError);
        }
        TcfContext tcfContext = setuidContext.getPrivacyContext().getTcfContext();
        if (tcfContext.isInGdprScope() && !tcfContext.isConsentValid()) {
            this.metrics.updateUserSyncTcfInvalidMetric(bidder);
            throw new InvalidRequestException("Consent string is invalid");
        }
        UidsCookie uidsCookie = setuidContext.getUidsCookie();
        if (!uidsCookie.allowsSync()) {
            throw new UnauthorizedUidsException("Sync is not allowed for this uids", tcfContext);
        }
        ActivityInfrastructure activityInfrastructure = setuidContext.getActivityInfrastructure();
        if (!activityInfrastructure.isAllowed(Activity.SYNC_USER, activityInvocationPayload = TcfContextActivityInvocationPayload.of(ActivityInvocationPayloadImpl.of(ComponentType.BIDDER, bidder), tcfContext))) {
            throw new UnavailableForLegalReasonsException();
        }
    }

    private Future<HostVendorTcfResponse> isAllowedForHostVendorId(TcfContext tcfContext) {
        Integer gdprHostVendorId = this.tcfDefinerService.getGdprHostVendorId();
        return gdprHostVendorId == null ? Future.succeededFuture((Object)HostVendorTcfResponse.allowedVendor()) : this.tcfDefinerService.resultForVendorIds(Collections.singleton(gdprHostVendorId), tcfContext).map(this::toHostVendorTcfResponse);
    }

    private HostVendorTcfResponse toHostVendorTcfResponse(TcfResponse<Integer> tcfResponse) {
        return HostVendorTcfResponse.of(tcfResponse.getUserInGdprScope(), tcfResponse.getCountry(), this.isSetuidAllowed(tcfResponse));
    }

    private boolean isSetuidAllowed(TcfResponse<Integer> hostTcfResponseToSetuidContext) {
        boolean notInGdprScope = BooleanUtils.isFalse((Boolean)hostTcfResponseToSetuidContext.getUserInGdprScope());
        Map<Integer, PrivacyEnforcementAction> vendorIdToAction = hostTcfResponseToSetuidContext.getActions();
        PrivacyEnforcementAction hostPrivacyAction = vendorIdToAction != null ? vendorIdToAction.get(this.tcfDefinerService.getGdprHostVendorId()) : null;
        boolean blockPixelSync = hostPrivacyAction == null || hostPrivacyAction.isBlockPixelSync();
        return notInGdprScope || !blockPixelSync;
    }

    private void respondByTcfResponse(AsyncResult<HostVendorTcfResponse> hostTcfResponseResult, SetuidContext setuidContext) {
        String bidderCookieName = setuidContext.getCookieName();
        TcfContext tcfContext = setuidContext.getPrivacyContext().getTcfContext();
        RoutingContext routingContext = setuidContext.getRoutingContext();
        if (hostTcfResponseResult.succeeded()) {
            HostVendorTcfResponse hostTcfResponse = (HostVendorTcfResponse)hostTcfResponseResult.result();
            if (hostTcfResponse.isVendorAllowed()) {
                this.respondWithCookie(setuidContext);
            } else {
                this.metrics.updateUserSyncTcfBlockedMetric(bidderCookieName);
                HttpResponseStatus status = new HttpResponseStatus(451, "Unavailable for legal reasons");
                HttpUtil.executeSafely(routingContext, Endpoint.setuid, response -> response.setStatusCode(status.code()).setStatusMessage(status.reasonPhrase()).end("The gdpr_consent param prevents cookies from being saved"));
                this.analyticsDelegator.processEvent(SetuidEvent.error(status.code()), tcfContext);
            }
        } else {
            Throwable error = hostTcfResponseResult.cause();
            this.metrics.updateUserSyncTcfBlockedMetric(bidderCookieName);
            this.handleErrors(error, routingContext, tcfContext);
        }
    }

    private void respondWithCookie(SetuidContext setuidContext) {
        RoutingContext routingContext = setuidContext.getRoutingContext();
        String uid = routingContext.request().getParam(UID_PARAM);
        String bidder = setuidContext.getCookieName();
        UidsCookieUpdateResult uidsCookieUpdateResult = this.uidsCookieService.updateUidsCookie(setuidContext.getUidsCookie(), bidder, uid);
        Cookie updatedUidsCookie = this.uidsCookieService.toCookie(uidsCookieUpdateResult.getUidsCookie());
        this.addCookie(routingContext, updatedUidsCookie);
        if (uidsCookieUpdateResult.isSuccessfullyUpdated()) {
            this.metrics.updateUserSyncSetsMetric(bidder);
        }
        int statusCode = HttpResponseStatus.OK.code();
        HttpUtil.executeSafely(routingContext, Endpoint.setuid, this.buildCookieResponseConsumer(setuidContext, statusCode));
        TcfContext tcfContext = setuidContext.getPrivacyContext().getTcfContext();
        SetuidEvent setuidEvent = SetuidEvent.builder().status(statusCode).bidder(bidder).uid(uid).success(uidsCookieUpdateResult.isSuccessfullyUpdated()).build();
        this.analyticsDelegator.processEvent(setuidEvent, tcfContext);
    }

    private Consumer<HttpServerResponse> buildCookieResponseConsumer(SetuidContext setuidContext, int responseStatusCode) {
        String format = setuidContext.getRoutingContext().request().getParam("f");
        return this.shouldRespondWithPixel(format, setuidContext.getSyncType()) ? response -> response.sendFile(PIXEL_FILE_PATH) : response -> response.setStatusCode(responseStatusCode).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"0").putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML).end();
    }

    private boolean shouldRespondWithPixel(String format, UsersyncMethodType syncType) {
        return UsersyncFormat.PIXEL.name.equals(format) || !UsersyncFormat.BLANK.name.equals(format) && syncType == UsersyncMethodType.REDIRECT;
    }

    private void handleErrors(Throwable error, RoutingContext routingContext, TcfContext tcfContext) {
        Object body;
        HttpResponseStatus status;
        String message = error.getMessage();
        if (error instanceof InvalidRequestException) {
            this.metrics.updateUserSyncBadRequestMetric();
            status = HttpResponseStatus.BAD_REQUEST;
            body = "Invalid request format: " + message;
        } else if (error instanceof UnauthorizedUidsException) {
            this.metrics.updateUserSyncOptoutMetric();
            status = HttpResponseStatus.UNAUTHORIZED;
            body = "Unauthorized: " + message;
        } else if (error instanceof UnavailableForLegalReasonsException) {
            status = HttpResponseStatus.valueOf((int)451);
            body = "Unavailable For Legal Reasons.";
        } else if (error instanceof InvalidAccountConfigException) {
            this.metrics.updateUserSyncBadRequestMetric();
            status = HttpResponseStatus.BAD_REQUEST;
            body = "Invalid account configuration: " + message;
        } else {
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            body = "Unexpected setuid processing error: " + message;
            logger.warn(body, error);
        }
        HttpUtil.executeSafely(routingContext, Endpoint.setuid, arg_0 -> SetuidHandler.lambda$handleErrors$8(status, (String)body, arg_0));
        SetuidEvent setuidEvent = SetuidEvent.error(status.code());
        if (tcfContext == null) {
            this.analyticsDelegator.processEvent(setuidEvent);
        } else {
            this.analyticsDelegator.processEvent(setuidEvent, tcfContext);
        }
    }

    private void addCookie(RoutingContext routingContext, Cookie cookie) {
        routingContext.response().headers().add(HttpUtil.SET_COOKIE_HEADER, (CharSequence)cookie.encode());
    }

    private static /* synthetic */ void lambda$handleErrors$8(HttpResponseStatus status, String body, HttpServerResponse response) {
        response.setStatusCode(status.code()).end(body);
    }
}

