/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.deals.UserService;
import org.prebid.server.deals.events.ApplicationEventService;
import org.prebid.server.events.EventRequest;
import org.prebid.server.events.EventUtil;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountEventsConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ResourceUtil;

public class NotificationEventHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(NotificationEventHandler.class);
    private static final String TRACKING_PIXEL_PNG = "static/tracking-pixel.png";
    private static final String PNG_CONTENT_TYPE = "image/png";
    private final UidsCookieService uidsCookieService;
    private final ApplicationEventService applicationEventService;
    private final UserService userService;
    private final ActivityInfrastructureCreator activityInfrastructureCreator;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final TimeoutFactory timeoutFactory;
    private final ApplicationSettings applicationSettings;
    private final long defaultTimeoutMillis;
    private final boolean dealsEnabled;
    private final TrackingPixel trackingPixel;

    public NotificationEventHandler(UidsCookieService uidsCookieService, ApplicationEventService applicationEventService, UserService userService, ActivityInfrastructureCreator activityInfrastructureCreator, AnalyticsReporterDelegator analyticsDelegator, TimeoutFactory timeoutFactory, ApplicationSettings applicationSettings, long defaultTimeoutMillis, boolean dealsEnabled) {
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.applicationEventService = applicationEventService;
        this.userService = userService;
        this.activityInfrastructureCreator = Objects.requireNonNull(activityInfrastructureCreator);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.defaultTimeoutMillis = defaultTimeoutMillis;
        this.dealsEnabled = dealsEnabled;
        this.trackingPixel = NotificationEventHandler.createTrackingPixel();
    }

    private static TrackingPixel createTrackingPixel() {
        byte[] bytes;
        try {
            bytes = ResourceUtil.readByteArrayFromClassPath(TRACKING_PIXEL_PNG);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load pixel image at static/tracking-pixel.png", e);
        }
        return TrackingPixel.of(PNG_CONTENT_TYPE, bytes);
    }

    public void handle(RoutingContext routingContext) {
        try {
            EventUtil.validateType(routingContext);
            EventUtil.validateBidId(routingContext);
            EventUtil.validateTimestamp(routingContext);
            EventUtil.validateFormat(routingContext);
            EventUtil.validateAnalytics(routingContext);
            EventUtil.validateIntegration(routingContext);
        }
        catch (IllegalArgumentException e) {
            NotificationEventHandler.respondWithBadRequest(routingContext, e.getMessage());
            return;
        }
        try {
            EventUtil.validateAccountId(routingContext);
        }
        catch (IllegalArgumentException e) {
            NotificationEventHandler.respondWithUnauthorized(routingContext, e.getMessage());
            return;
        }
        EventRequest eventRequest = EventUtil.from(routingContext);
        this.getAccountById(eventRequest.getAccountId()).onComplete(async -> this.handleEvent((AsyncResult<Account>)async, eventRequest, routingContext));
    }

    private Future<Account> getAccountById(String accountId) {
        return this.applicationSettings.getAccountById(accountId, this.timeoutFactory.create(this.defaultTimeoutMillis)).recover(exception -> NotificationEventHandler.handleAccountExceptionOrFallback(exception, accountId));
    }

    private static Future<Account> handleAccountExceptionOrFallback(Throwable exception, String accountId) {
        if (exception instanceof PreBidException) {
            return Future.succeededFuture((Object)Account.builder().id(accountId).auction(AccountAuctionConfig.builder().events(AccountEventsConfig.of(false)).build()).build());
        }
        return Future.failedFuture((Throwable)exception);
    }

    private void handleEvent(AsyncResult<Account> async, EventRequest eventRequest, RoutingContext routingContext) {
        if (async.failed()) {
            NotificationEventHandler.respondWithServerError(routingContext, "Error occurred while fetching account", async.cause());
        } else {
            boolean eventsEnabledForRequest;
            Account account = (Account)async.result();
            String lineItemId = eventRequest.getLineItemId();
            String bidId = eventRequest.getBidId();
            if (this.dealsEnabled && lineItemId != null) {
                this.applicationEventService.publishLineItemWinEvent(lineItemId);
                this.userService.processWinEvent(lineItemId, bidId, this.uidsCookieService.parseFromRequest(routingContext));
            }
            boolean eventsEnabledForAccount = Objects.equals(NotificationEventHandler.accountEventsEnabled(account), true);
            boolean bl = eventsEnabledForRequest = eventRequest.getAnalytics() == EventRequest.Analytics.enabled;
            if (!eventsEnabledForAccount && eventsEnabledForRequest) {
                NotificationEventHandler.respondWithUnauthorized(routingContext, "Account '%s' doesn't support events".formatted(account.getId()));
                return;
            }
            EventRequest.Type eventType = eventRequest.getType();
            if (eventsEnabledForRequest) {
                NotificationEvent notificationEvent = NotificationEvent.builder().type(eventType == EventRequest.Type.win ? NotificationEvent.Type.win : NotificationEvent.Type.imp).bidId(eventRequest.getBidId()).account(account).bidder(eventRequest.getBidder()).timestamp(eventRequest.getTimestamp()).integration(eventRequest.getIntegration()).httpContext(HttpRequestContext.from(routingContext)).lineItemId(lineItemId).activityInfrastructure(this.activityInfrastructure(account)).build();
                this.analyticsDelegator.processEvent(notificationEvent);
            }
            this.respondWithOk(routingContext, eventRequest.getFormat() == EventRequest.Format.image);
        }
    }

    private static Boolean accountEventsEnabled(Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        AccountEventsConfig accountEventsConfig = accountAuctionConfig != null ? accountAuctionConfig.getEvents() : null;
        return accountEventsConfig != null ? accountEventsConfig.getEnabled() : null;
    }

    private ActivityInfrastructure activityInfrastructure(Account account) {
        return this.activityInfrastructureCreator.create(account, GppContextCreator.from(null, null).build().getGppContext(), null);
    }

    private void respondWithOk(RoutingContext routingContext, boolean respondWithPixel) {
        if (respondWithPixel) {
            HttpUtil.executeSafely(routingContext, Endpoint.event, response -> response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.trackingPixel.getContentType()).end(Buffer.buffer((byte[])this.trackingPixel.getContent())));
        } else {
            HttpUtil.executeSafely(routingContext, Endpoint.event, HttpServerResponse::end);
        }
    }

    private static void respondWithBadRequest(RoutingContext routingContext, String message) {
        NotificationEventHandler.respondWith(routingContext, HttpResponseStatus.BAD_REQUEST, message);
    }

    private static void respondWithUnauthorized(RoutingContext routingContext, String message) {
        NotificationEventHandler.respondWith(routingContext, HttpResponseStatus.UNAUTHORIZED, message);
    }

    private static void respondWithServerError(RoutingContext routingContext, String message, Throwable exception) {
        logger.warn((Object)message, exception);
        String body = "%s: %s".formatted(message, exception.getMessage());
        NotificationEventHandler.respondWith(routingContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, body);
    }

    private static void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body) {
        HttpUtil.executeSafely(routingContext, Endpoint.event, response -> response.setStatusCode(status.code()).end(body));
    }

    private static final class TrackingPixel {
        private final String contentType;
        private final byte[] content;

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackingPixel)) {
                return false;
            }
            TrackingPixel other = (TrackingPixel)o;
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            return Arrays.equals(this.getContent(), other.getContent());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            result = result * 59 + Arrays.hashCode(this.getContent());
            return result;
        }

        public String toString() {
            return "NotificationEventHandler.TrackingPixel(contentType=" + this.getContentType() + ", content=" + Arrays.toString(this.getContent()) + ")";
        }

        @ConstructorProperties(value={"contentType", "content"})
        private TrackingPixel(String contentType, byte[] content) {
            this.contentType = contentType;
            this.content = content;
        }

        public static TrackingPixel of(String contentType, byte[] content) {
            return new TrackingPixel(contentType, content);
        }
    }
}

