/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.geolocation;

import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import io.vertx.core.Future;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.execution.RemoteFileProcessor;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;

public class MaxMindGeoLocationService
implements GeoLocationService,
RemoteFileProcessor {
    private static final String VENDOR = "maxmind";
    private static final String DATABASE_FILE_NAME = "GeoLite2-City.mmdb";
    private DatabaseReader databaseReader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Future<?> setDataPath(String dataFilePath) {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(dataFilePath)));){
            TarArchiveEntry currentEntry;
            boolean hasDatabaseFile = false;
            while ((currentEntry = tarInput.getNextTarEntry()) != null) {
                if (!currentEntry.getName().contains(DATABASE_FILE_NAME)) continue;
                hasDatabaseFile = true;
                break;
            }
            if (!hasDatabaseFile) {
                Future future = Future.failedFuture((String)"Database file %s not found in %s archive".formatted(DATABASE_FILE_NAME, dataFilePath));
                return future;
            }
            this.databaseReader = new DatabaseReader.Builder((InputStream)tarInput).fileMode(Reader.FileMode.MEMORY).build();
            Future future = Future.succeededFuture();
            return future;
        }
        catch (IOException e) {
            return Future.failedFuture((String)("IO Exception occurred while trying to read an archive/db file: " + e.getMessage()));
        }
    }

    @Override
    public Future<GeoInfo> lookup(String ip, Timeout timeout) {
        if (this.databaseReader == null) {
            return Future.failedFuture((String)"Geo location database file hasn't been downloaded yet, try again later");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(ip);
            CityResponse cityResponse = this.databaseReader.city(inetAddress);
            Location location = cityResponse != null ? cityResponse.getLocation() : null;
            return Future.succeededFuture((Object)GeoInfo.builder().vendor(VENDOR).continent(MaxMindGeoLocationService.resolveContinent(cityResponse)).country(MaxMindGeoLocationService.resolveCountry(cityResponse)).region(MaxMindGeoLocationService.resolveRegion(cityResponse)).city(MaxMindGeoLocationService.resolveCity(cityResponse)).lat(MaxMindGeoLocationService.resolveLatitude(location)).lon(MaxMindGeoLocationService.resolveLongitude(location)).build());
        }
        catch (GeoIp2Exception | IOException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private static String resolveContinent(CityResponse cityResponse) {
        Continent continent = cityResponse != null ? cityResponse.getContinent() : null;
        String code = continent != null ? continent.getCode() : null;
        return StringUtils.lowerCase((String)code);
    }

    private static String resolveCountry(CityResponse cityResponse) {
        Country country = cityResponse != null ? cityResponse.getCountry() : null;
        String isoCode = country != null ? country.getIsoCode() : null;
        return StringUtils.lowerCase((String)isoCode);
    }

    private static String resolveRegion(CityResponse cityResponse) {
        List subdivisions = cityResponse != null ? cityResponse.getSubdivisions() : null;
        Subdivision firstSubdivision = CollectionUtils.isEmpty((Collection)subdivisions) ? null : (Subdivision)subdivisions.get(0);
        return firstSubdivision != null ? firstSubdivision.getIsoCode() : null;
    }

    private static String resolveCity(CityResponse cityResponse) {
        City city = cityResponse != null ? cityResponse.getCity() : null;
        return city != null ? city.getName() : null;
    }

    private static Float resolveLatitude(Location location) {
        Double latitude = location != null ? location.getLatitude() : null;
        return latitude != null ? Float.valueOf(latitude.floatValue()) : null;
    }

    private static Float resolveLongitude(Location location) {
        Double longitude = location != null ? location.getLongitude() : null;
        return longitude != null ? Float.valueOf(longitude.floatValue()) : null;
    }
}

