/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.events;

import java.util.Objects;
import org.prebid.server.events.EventRequest;
import org.prebid.server.events.EventUtil;
import org.prebid.server.events.EventsContext;
import org.prebid.server.proto.openrtb.ext.response.Events;
import org.prebid.server.util.HttpUtil;

public class EventsService {
    private final String externalUrl;

    public EventsService(String externalUrl) {
        this.externalUrl = HttpUtil.validateUrl(Objects.requireNonNull(externalUrl));
    }

    public Events createEvent(String bidId, String bidder, String accountId, String lineItemId, boolean analyticsEnabled, EventsContext eventsContext) {
        return Events.of(this.eventUrl(EventRequest.Type.win, bidId, bidder, accountId, lineItemId, EventsService.analytics(analyticsEnabled), EventRequest.Format.image, eventsContext), this.eventUrl(EventRequest.Type.imp, bidId, bidder, accountId, lineItemId, EventsService.analytics(analyticsEnabled), EventRequest.Format.image, eventsContext));
    }

    public String winUrl(String bidId, String bidder, String accountId, String lineItemId, boolean analyticsEnabled, EventsContext eventsContext) {
        return this.eventUrl(EventRequest.Type.win, bidId, bidder, accountId, lineItemId, EventsService.analytics(analyticsEnabled), EventRequest.Format.image, eventsContext);
    }

    public String vastUrlTracking(String bidId, String bidder, String accountId, String lineItemId, EventsContext eventsContext) {
        return this.eventUrl(EventRequest.Type.imp, bidId, bidder, accountId, lineItemId, null, EventRequest.Format.blank, eventsContext);
    }

    private String eventUrl(EventRequest.Type type, String bidId, String bidder, String accountId, String lineItemId, EventRequest.Analytics analytics, EventRequest.Format format, EventsContext eventsContext) {
        EventRequest eventRequest = EventRequest.builder().type(type).bidId(bidId).auctionId(eventsContext.getAuctionId()).accountId(accountId).bidder(bidder).timestamp(eventsContext.getAuctionTimestamp()).format(format).integration(eventsContext.getIntegration()).lineItemId(lineItemId).analytics(analytics).build();
        return EventUtil.toUrl(this.externalUrl, eventRequest);
    }

    private static EventRequest.Analytics analytics(boolean analyticsEnabled) {
        return analyticsEnabled ? null : EventRequest.Analytics.disabled;
    }
}

