/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.simulation;

import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.PlannerService;
import org.prebid.server.deals.model.AlertPriority;
import org.prebid.server.deals.model.DeploymentProperties;
import org.prebid.server.deals.model.PlannerProperties;
import org.prebid.server.deals.proto.LineItemMetaData;
import org.prebid.server.deals.simulation.SimulationAwareLineItemService;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.http.HttpClient;

public class SimulationAwarePlannerService
extends PlannerService {
    private static final Logger logger = LoggerFactory.getLogger(SimulationAwarePlannerService.class);
    private static final DateTimeFormatter UTC_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter();
    private static final String PG_SIM_TIMESTAMP = "pg-sim-timestamp";
    private static final String PBS_PLANNER_CLIENT_ERROR = "pbs-planner-client-error";
    private final SimulationAwareLineItemService lineItemService;
    private final Metrics metrics;
    private final AlertHttpService alertHttpService;
    private List<LineItemMetaData> lineItemMetaData;

    public SimulationAwarePlannerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, SimulationAwareLineItemService lineItemService, DeliveryProgressService deliveryProgressService, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, JacksonMapper mapper) {
        super(plannerProperties, deploymentProperties, lineItemService, deliveryProgressService, alertHttpService, httpClient, metrics, clock, mapper);
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.alertHttpService = Objects.requireNonNull(alertHttpService);
        this.metrics = Objects.requireNonNull(metrics);
        this.lineItemMetaData = new ArrayList<LineItemMetaData>();
    }

    public void advancePlans(ZonedDateTime now) {
        this.lineItemService.updateLineItems(this.lineItemMetaData, this.isPlannerResponsive.get(), now);
        this.lineItemService.advanceToNextPlan(now);
    }

    public void initiateLineItemsFetching(ZonedDateTime now) {
        this.fetchLineItemMetaData(this.planEndpoint, this.headers(now)).onComplete(this::handleInitializationResult);
    }

    @Override
    protected void handleInitializationResult(AsyncResult<List<LineItemMetaData>> plannerResponse) {
        if (plannerResponse.succeeded()) {
            this.metrics.updatePlannerRequestMetric(true);
            this.isPlannerResponsive.set(true);
            this.lineItemService.updateIsPlannerResponsive(true);
            this.lineItemMetaData = (List)plannerResponse.result();
        } else {
            this.alert(plannerResponse.cause().getMessage(), AlertPriority.HIGH, arg_0 -> ((Logger)logger).warn(arg_0));
            logger.warn((Object)"Failed to retrieve line items from Planner after retry. Reason: {0}", new Object[]{plannerResponse.cause().getMessage()});
            this.isPlannerResponsive.set(false);
            this.lineItemService.updateIsPlannerResponsive(false);
            this.metrics.updatePlannerRequestMetric(false);
        }
    }

    private MultiMap headers(ZonedDateTime now) {
        return this.headers().add(PG_SIM_TIMESTAMP, UTC_MILLIS_FORMATTER.format(now));
    }

    private void alert(String message, AlertPriority alertPriority, Consumer<String> logger) {
        this.alertHttpService.alert(PBS_PLANNER_CLIENT_ERROR, alertPriority, message);
        logger.accept(message);
    }
}

