/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;

public final class PlannerProperties {
    @NonNull
    private final String planEndpoint;
    @NonNull
    private final String registerEndpoint;
    private final long timeoutMs;
    private final long registerPeriodSeconds;
    @NonNull
    private final String username;
    @NonNull
    private final String password;

    @ConstructorProperties(value={"planEndpoint", "registerEndpoint", "timeoutMs", "registerPeriodSeconds", "username", "password"})
    PlannerProperties(@NonNull String planEndpoint, @NonNull String registerEndpoint, long timeoutMs, long registerPeriodSeconds, @NonNull String username, @NonNull String password) {
        if (planEndpoint == null) {
            throw new NullPointerException("planEndpoint is marked non-null but is null");
        }
        if (registerEndpoint == null) {
            throw new NullPointerException("registerEndpoint is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.planEndpoint = planEndpoint;
        this.registerEndpoint = registerEndpoint;
        this.timeoutMs = timeoutMs;
        this.registerPeriodSeconds = registerPeriodSeconds;
        this.username = username;
        this.password = password;
    }

    public static PlannerPropertiesBuilder builder() {
        return new PlannerPropertiesBuilder();
    }

    @NonNull
    public String getPlanEndpoint() {
        return this.planEndpoint;
    }

    @NonNull
    public String getRegisterEndpoint() {
        return this.registerEndpoint;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public long getRegisterPeriodSeconds() {
        return this.registerPeriodSeconds;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlannerProperties)) {
            return false;
        }
        PlannerProperties other = (PlannerProperties)o;
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.getRegisterPeriodSeconds() != other.getRegisterPeriodSeconds()) {
            return false;
        }
        String this$planEndpoint = this.getPlanEndpoint();
        String other$planEndpoint = other.getPlanEndpoint();
        if (this$planEndpoint == null ? other$planEndpoint != null : !this$planEndpoint.equals(other$planEndpoint)) {
            return false;
        }
        String this$registerEndpoint = this.getRegisterEndpoint();
        String other$registerEndpoint = other.getRegisterEndpoint();
        if (this$registerEndpoint == null ? other$registerEndpoint != null : !this$registerEndpoint.equals(other$registerEndpoint)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeoutMs = this.getTimeoutMs();
        result = result * 59 + (int)($timeoutMs >>> 32 ^ $timeoutMs);
        long $registerPeriodSeconds = this.getRegisterPeriodSeconds();
        result = result * 59 + (int)($registerPeriodSeconds >>> 32 ^ $registerPeriodSeconds);
        String $planEndpoint = this.getPlanEndpoint();
        result = result * 59 + ($planEndpoint == null ? 43 : $planEndpoint.hashCode());
        String $registerEndpoint = this.getRegisterEndpoint();
        result = result * 59 + ($registerEndpoint == null ? 43 : $registerEndpoint.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "PlannerProperties(planEndpoint=" + this.getPlanEndpoint() + ", registerEndpoint=" + this.getRegisterEndpoint() + ", timeoutMs=" + this.getTimeoutMs() + ", registerPeriodSeconds=" + this.getRegisterPeriodSeconds() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public static class PlannerPropertiesBuilder {
        private String planEndpoint;
        private String registerEndpoint;
        private long timeoutMs;
        private long registerPeriodSeconds;
        private String username;
        private String password;

        PlannerPropertiesBuilder() {
        }

        public PlannerPropertiesBuilder planEndpoint(@NonNull String planEndpoint) {
            if (planEndpoint == null) {
                throw new NullPointerException("planEndpoint is marked non-null but is null");
            }
            this.planEndpoint = planEndpoint;
            return this;
        }

        public PlannerPropertiesBuilder registerEndpoint(@NonNull String registerEndpoint) {
            if (registerEndpoint == null) {
                throw new NullPointerException("registerEndpoint is marked non-null but is null");
            }
            this.registerEndpoint = registerEndpoint;
            return this;
        }

        public PlannerPropertiesBuilder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public PlannerPropertiesBuilder registerPeriodSeconds(long registerPeriodSeconds) {
            this.registerPeriodSeconds = registerPeriodSeconds;
            return this;
        }

        public PlannerPropertiesBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        public PlannerPropertiesBuilder password(@NonNull String password) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.password = password;
            return this;
        }

        public PlannerProperties build() {
            return new PlannerProperties(this.planEndpoint, this.registerEndpoint, this.timeoutMs, this.registerPeriodSeconds, this.username, this.password);
        }

        public String toString() {
            return "PlannerProperties.PlannerPropertiesBuilder(planEndpoint=" + this.planEndpoint + ", registerEndpoint=" + this.registerEndpoint + ", timeoutMs=" + this.timeoutMs + ", registerPeriodSeconds=" + this.registerPeriodSeconds + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

