/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.lineitem;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.prebid.server.deals.lineitem.DeliveryPlan;
import org.prebid.server.deals.proto.DeliverySchedule;
import org.prebid.server.deals.proto.FrequencyCap;
import org.prebid.server.deals.proto.LineItemMetaData;
import org.prebid.server.deals.proto.LineItemSize;
import org.prebid.server.deals.proto.Price;
import org.prebid.server.deals.targeting.TargetingDefinition;

public class LineItem {
    private static final Logger logger = LoggerFactory.getLogger(LineItem.class);
    private final LineItemMetaData metaData;
    private final Price normalizedPrice;
    private final List<String> fcapIds;
    private final TargetingDefinition targetingDefinition;
    private final AtomicReference<DeliveryPlan> activeDeliveryPlan;
    private final AtomicReference<ZonedDateTime> readyAt;

    private LineItem(LineItemMetaData metaData, Price normalizedPrice, TargetingDefinition targetingDefinition) {
        this.metaData = Objects.requireNonNull(metaData);
        this.normalizedPrice = normalizedPrice;
        this.targetingDefinition = targetingDefinition;
        this.fcapIds = LineItem.extractFcapIds(metaData);
        this.activeDeliveryPlan = new AtomicReference();
        this.readyAt = new AtomicReference();
    }

    private LineItem(LineItemMetaData metaData, Price normalizedPrice, TargetingDefinition targetingDefinition, ZonedDateTime readyAt, ZonedDateTime now, DeliveryPlan currentPlan) {
        this(metaData, normalizedPrice, targetingDefinition);
        this.readyAt.set(readyAt);
        this.updateOrAdvanceActivePlan(now, true, currentPlan);
    }

    private LineItem(LineItemMetaData metaData, Price normalizedPrice, TargetingDefinition targetingDefinition, ZonedDateTime now) {
        this(metaData, normalizedPrice, targetingDefinition, null, now, null);
    }

    public static LineItem of(LineItemMetaData metaData, Price normalizedPrice, TargetingDefinition targetingDefinition, ZonedDateTime now) {
        return new LineItem(metaData, normalizedPrice, targetingDefinition, now);
    }

    public LineItem withUpdatedMetadata(LineItemMetaData metaData, Price normalizedPrice, TargetingDefinition targetingDefinition, ZonedDateTime readyAt, ZonedDateTime now) {
        return new LineItem(metaData, normalizedPrice, targetingDefinition, readyAt, now, this.getActiveDeliveryPlan());
    }

    public void advanceToNextPlan(ZonedDateTime now, boolean isPlannerResponsive) {
        this.updateOrAdvanceActivePlan(now, isPlannerResponsive, this.getActiveDeliveryPlan());
    }

    public Integer incSpentToken(ZonedDateTime now) {
        return this.incSpentToken(now, 0L);
    }

    public Integer incSpentToken(ZonedDateTime now, long adjustment) {
        DeliveryPlan deliveryPlan = this.activeDeliveryPlan.get();
        if (deliveryPlan != null) {
            Integer tokenClassIncremented = deliveryPlan.incSpentToken();
            ZonedDateTime readyAtNewValue = deliveryPlan.calculateReadyAt();
            readyAtNewValue = readyAtNewValue != null && adjustment != 0L ? readyAtNewValue.plusNanos(TimeUnit.MILLISECONDS.toNanos(adjustment)) : readyAtNewValue;
            this.readyAt.set(readyAtNewValue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ReadyAt for lineItem {0} plan {1} was updated to {2} after token was spent. Total number of unspent token is {3}. Current time is {4}", new Object[]{this.getLineItemId(), deliveryPlan.getPlanId(), this.readyAt.get(), deliveryPlan.getUnspentTokens(), now});
            }
            return tokenClassIncremented;
        }
        return null;
    }

    public Integer getHighestUnspentTokensClass() {
        DeliveryPlan activeDeliveryPlan = this.getActiveDeliveryPlan();
        return activeDeliveryPlan != null ? activeDeliveryPlan.getHighestUnspentTokensClass() : null;
    }

    public boolean isActive(ZonedDateTime now) {
        return LineItem.dateBetween(now, this.metaData.getStartTimeStamp(), this.metaData.getEndTimeStamp());
    }

    public DeliveryPlan getActiveDeliveryPlan() {
        return this.activeDeliveryPlan.get();
    }

    public ZonedDateTime getReadyAt() {
        return this.readyAt.get();
    }

    public BigDecimal getCpm() {
        if (this.normalizedPrice != null) {
            return this.normalizedPrice.getCpm();
        }
        return null;
    }

    public String getCurrency() {
        if (this.normalizedPrice != null) {
            return this.normalizedPrice.getCurrency();
        }
        return null;
    }

    public String getLineItemId() {
        return this.metaData.getLineItemId();
    }

    public String getExtLineItemId() {
        return this.metaData.getExtLineItemId();
    }

    public String getDealId() {
        return this.metaData.getDealId();
    }

    public String getAccountId() {
        return this.metaData.getAccountId();
    }

    public String getSource() {
        return this.metaData.getSource();
    }

    public Integer getRelativePriority() {
        return this.metaData.getRelativePriority();
    }

    public ZonedDateTime getEndTimeStamp() {
        return this.metaData.getEndTimeStamp();
    }

    public ZonedDateTime getStartTimeStamp() {
        return this.metaData.getStartTimeStamp();
    }

    public ZonedDateTime getUpdatedTimeStamp() {
        return this.metaData.getUpdatedTimeStamp();
    }

    public List<FrequencyCap> getFrequencyCaps() {
        return this.metaData.getFrequencyCaps();
    }

    public List<LineItemSize> getSizes() {
        return this.metaData.getSizes();
    }

    public ObjectNode getTargeting() {
        return this.metaData.getTargeting();
    }

    public TargetingDefinition getTargetingDefinition() {
        return this.targetingDefinition;
    }

    public List<String> getFcapIds() {
        return this.fcapIds;
    }

    private static List<String> extractFcapIds(LineItemMetaData metaData) {
        return CollectionUtils.emptyIfNull(metaData.getFrequencyCaps()).stream().map(FrequencyCap::getFcapId).toList();
    }

    private void updateOrAdvanceActivePlan(ZonedDateTime now, boolean isPlannerResponsive, DeliveryPlan currentPlan) {
        DeliverySchedule currentSchedule = ListUtils.emptyIfNull(this.metaData.getDeliverySchedules()).stream().filter(schedule -> LineItem.dateBetween(now, schedule.getStartTimeStamp(), schedule.getEndTimeStamp())).findFirst().orElse(null);
        if (currentSchedule != null) {
            DeliveryPlan resolvedPlan = LineItem.resolveActivePlan(currentPlan, currentSchedule, isPlannerResponsive);
            ZonedDateTime readyAtBeforeUpdate = this.readyAt.get();
            if (currentPlan != resolvedPlan) {
                this.readyAt.set(currentPlan == null || !Objects.equals(currentSchedule.getPlanId(), currentPlan.getPlanId()) ? this.calculateReadyAfterMovingToNextPlan(now, resolvedPlan) : this.calculateReadyAtAfterPlanUpdated(now, resolvedPlan));
                logger.info((Object)"ReadyAt for Line Item `{0}` was updated from plan {1} to {2} and readyAt from {3} to {4} at time is {5}", new Object[]{this.getLineItemId(), currentPlan != null ? currentPlan.getPlanId() : " no plan ", resolvedPlan.getPlanId(), readyAtBeforeUpdate, this.getReadyAt(), now});
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unspent tokens number for plan {0} is {1}", new Object[]{resolvedPlan.getPlanId(), resolvedPlan.getUnspentTokens()});
                }
            }
            this.activeDeliveryPlan.set(resolvedPlan);
        } else {
            this.activeDeliveryPlan.set(null);
            this.readyAt.set(null);
            logger.info((Object)"Active plan for Line Item `{0}` was not found at time is {1}, readyAt updated with 'never', until active plan become available", new Object[]{this.getLineItemId(), now});
        }
    }

    private ZonedDateTime calculateReadyAtAfterPlanUpdated(ZonedDateTime now, DeliveryPlan resolvedPlan) {
        ZonedDateTime resolvedReadyAt = resolvedPlan.calculateReadyAt();
        logger.debug((Object)"Current plan for Line Item `{0}` was considered as updated from GP response and readyAt will be updated from {1} to {2} at time is {3}", new Object[]{this.getLineItemId(), this.getReadyAt(), resolvedReadyAt, now});
        return resolvedReadyAt;
    }

    private ZonedDateTime calculateReadyAfterMovingToNextPlan(ZonedDateTime now, DeliveryPlan resolvedPlan) {
        return resolvedPlan.getDeliveryTokens().stream().anyMatch(deliveryToken -> deliveryToken.getTotal() > 0) ? now : null;
    }

    private static DeliveryPlan resolveActivePlan(DeliveryPlan currentPlan, DeliverySchedule currentSchedule, boolean isPlannerResponsive) {
        if (currentPlan != null) {
            if (Objects.equals(currentPlan.getPlanId(), currentSchedule.getPlanId())) {
                return currentPlan.getUpdatedTimeStamp().isBefore(currentSchedule.getUpdatedTimeStamp()) ? currentPlan.mergeWithNextDeliverySchedule(currentSchedule, false) : currentPlan;
            }
            if (!isPlannerResponsive) {
                return currentPlan.mergeWithNextDeliverySchedule(currentSchedule, true);
            }
        }
        return DeliveryPlan.of(currentSchedule);
    }

    private static boolean dateBetween(ZonedDateTime now, ZonedDateTime startDate, ZonedDateTime expirationDate) {
        return (now.isEqual(startDate) || now.isAfter(startDate)) && now.isBefore(expirationDate);
    }
}

