/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie.model;

import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public final class UidWithExpiry {
    private static final long LIVE_TTL_MS = Duration.ofDays(14L).toMillis();
    private static final long EXPIRED_TTL_MS = Duration.ofMinutes(5L).toMillis();
    private final String uid;
    private final ZonedDateTime expires;

    public static UidWithExpiry live(String uid) {
        return UidWithExpiry.create(uid, LIVE_TTL_MS);
    }

    public static UidWithExpiry expired(String uid) {
        return UidWithExpiry.create(uid, -EXPIRED_TTL_MS);
    }

    private static UidWithExpiry create(String uid, long ttlMs) {
        return new UidWithExpiry(uid, ZonedDateTime.now(Clock.systemUTC()).plus(ttlMs, ChronoUnit.MILLIS));
    }

    public String getUid() {
        return this.uid;
    }

    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UidWithExpiry)) {
            return false;
        }
        UidWithExpiry other = (UidWithExpiry)o;
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        ZonedDateTime this$expires = this.getExpires();
        ZonedDateTime other$expires = other.getExpires();
        return !(this$expires == null ? other$expires != null : !((Object)this$expires).equals(other$expires));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        ZonedDateTime $expires = this.getExpires();
        result = result * 59 + ($expires == null ? 43 : ((Object)$expires).hashCode());
        return result;
    }

    public String toString() {
        return "UidWithExpiry(uid=" + this.getUid() + ", expires=" + this.getExpires() + ")";
    }

    @ConstructorProperties(value={"uid", "expires"})
    public UidWithExpiry(String uid, ZonedDateTime expires) {
        this.uid = uid;
        this.expires = expires;
    }
}

