/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountCookieSyncConfig;

public class PrioritizedCoopSyncProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrioritizedCoopSyncProvider.class);
    private final Set<String> prioritizedBidders;
    private final Map<String, String> prioritizedCookieFamilyNameToBidderName;

    public PrioritizedCoopSyncProvider(Set<String> bidders, BidderCatalog bidderCatalog) {
        this.prioritizedBidders = PrioritizedCoopSyncProvider.validCoopSyncBidders(Objects.requireNonNull(bidders), bidderCatalog);
        this.prioritizedCookieFamilyNameToBidderName = this.prioritizedBidders.stream().collect(Collectors.toMap(bidder -> bidderCatalog.cookieFamilyName((String)bidder).orElseThrow(), Function.identity()));
    }

    private static Set<String> validCoopSyncBidders(Set<String> bidders, BidderCatalog bidderCatalog) {
        HashSet<String> validBidders = new HashSet<String>();
        for (String bidder : bidders) {
            if (!bidderCatalog.isValidName(bidder)) {
                logger.info((Object)"bidder {0} is provided for prioritized coop-syncing, but is invalid bidder name, ignoring", new Object[]{bidder});
                continue;
            }
            if (!bidderCatalog.isActive(bidder)) {
                logger.info((Object)"bidder {0} is provided for prioritized coop-syncing, but disabled in current pbs instance, ignoring", new Object[]{bidder});
                continue;
            }
            if (bidderCatalog.usersyncerByName(bidder).isEmpty()) {
                logger.info((Object)"bidder {0} is provided for prioritized coop-syncing, but has no user-sync configuration, ignoring", new Object[]{bidder});
                continue;
            }
            validBidders.add(bidder);
        }
        return validBidders;
    }

    public Set<String> prioritizedBidders(Account account) {
        Set<String> resolvedBidders = Optional.ofNullable(account).map(Account::getCookieSync).map(AccountCookieSyncConfig::getPrioritizedBidders).filter(bidders -> !bidders.isEmpty()).orElse(this.prioritizedBidders);
        ArrayList<String> shuffledBidders = new ArrayList<String>(resolvedBidders);
        Collections.shuffle(shuffledBidders);
        return new LinkedHashSet<String>(shuffledBidders);
    }

    public boolean isPrioritizedFamily(String cookieFamilyName) {
        String bidder = this.prioritizedCookieFamilyNameToBidderName.get(cookieFamilyName);
        return this.prioritizedBidders.contains(bidder);
    }

    public boolean hasPrioritizedBidders() {
        return !this.prioritizedBidders.isEmpty();
    }
}

