/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie;

import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.payload.impl.ActivityInvocationPayloadImpl;
import org.prebid.server.activity.infrastructure.payload.impl.TcfContextActivityInvocationPayload;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.bidder.UsersyncInfoBuilder;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncUtil;
import org.prebid.server.bidder.Usersyncer;
import org.prebid.server.cookie.CoopSyncProvider;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.cookie.exception.CookieSyncException;
import org.prebid.server.cookie.exception.InvalidCookieSyncRequestException;
import org.prebid.server.cookie.exception.UnauthorizedUidsException;
import org.prebid.server.cookie.model.BiddersContext;
import org.prebid.server.cookie.model.CookieSyncContext;
import org.prebid.server.cookie.model.CookieSyncStatus;
import org.prebid.server.cookie.model.RejectionReason;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.HostVendorTcfDefinerService;
import org.prebid.server.privacy.gdpr.model.HostVendorTcfResponse;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.proto.response.BidderUsersyncStatus;
import org.prebid.server.proto.response.CookieSyncResponse;
import org.prebid.server.proto.response.UsersyncInfo;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountCookieSyncConfig;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.AccountPrivacyConfig;
import org.prebid.server.spring.config.bidder.model.usersync.CookieFamilySource;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class CookieSyncService {
    private final String externalUrl;
    private final int defaultLimit;
    private final int maxLimit;
    private final BidderCatalog bidderCatalog;
    private final HostVendorTcfDefinerService tcfDefinerService;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final UidsCookieService uidsCookieService;
    private final CoopSyncProvider coopSyncProvider;
    private final Metrics metrics;

    public CookieSyncService(String externalUrl, int defaultLimit, int maxLimit, BidderCatalog bidderCatalog, HostVendorTcfDefinerService tcfDefinerService, PrivacyEnforcementService privacyEnforcementService, UidsCookieService uidsCookieService, CoopSyncProvider coopSyncProvider, Metrics metrics) {
        this.externalUrl = HttpUtil.validateUrl(Objects.requireNonNull(externalUrl));
        CookieSyncService.validateLimits(defaultLimit, maxLimit);
        this.defaultLimit = defaultLimit;
        this.maxLimit = maxLimit;
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.tcfDefinerService = Objects.requireNonNull(tcfDefinerService);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.coopSyncProvider = Objects.requireNonNull(coopSyncProvider);
        this.metrics = Objects.requireNonNull(metrics);
    }

    private static void validateLimits(int limit, int maxLimit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Default cookie-sync limit should be greater than 0");
        }
        if (maxLimit < limit) {
            throw new IllegalArgumentException("Max cookie-sync limit should be greater or equal than limit");
        }
    }

    public Future<CookieSyncContext> processContext(CookieSyncContext cookieSyncContext) {
        return Future.succeededFuture((Object)cookieSyncContext).map(this::validateCookieSyncContext).map(this::resolveLimit).map(this::resolveBiddersToSync).map(this::filterInvalidBidders).map(this::filterDisabledBidders).map(this::filterBiddersWithoutUsersync).map(this::filterBiddersWithDisabledUsersync).map(this::applyRequestFilterSettings).compose(this::applyPrivacyFilteringRules).map(this::filterInSyncBidders);
    }

    private CookieSyncContext validateCookieSyncContext(CookieSyncContext cookieSyncContext) {
        TcfContext tcfContext = cookieSyncContext.getPrivacyContext().getTcfContext();
        UidsCookie uidsCookie = cookieSyncContext.getUidsCookie();
        if (!uidsCookie.allowsSync()) {
            throw new UnauthorizedUidsException("Sync is not allowed for this uids", tcfContext);
        }
        CookieSyncRequest cookieSyncRequest = cookieSyncContext.getCookieSyncRequest();
        if (CookieSyncService.isGdprParamsInconsistent(cookieSyncRequest)) {
            throw new InvalidCookieSyncRequestException("gdpr_consent is required if gdpr is 1", tcfContext);
        }
        if (tcfContext.isInGdprScope() && !tcfContext.isConsentValid()) {
            this.metrics.updateUserSyncTcfInvalidMetric();
            throw new InvalidCookieSyncRequestException("Consent string is invalid", tcfContext);
        }
        return cookieSyncContext;
    }

    private static boolean isGdprParamsInconsistent(CookieSyncRequest request) {
        return Objects.equals(request.getGdpr(), 1) && StringUtils.isBlank((CharSequence)request.getGdprConsent());
    }

    private CookieSyncContext resolveLimit(CookieSyncContext cookieSyncContext) {
        AccountCookieSyncConfig accountCookieSyncConfig = cookieSyncContext.getAccount().getCookieSync();
        int resolvedLimit = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{cookieSyncContext.getCookieSyncRequest().getLimit(), ObjectUtil.getIfNotNull(accountCookieSyncConfig, AccountCookieSyncConfig::getDefaultLimit), this.defaultLimit});
        int adjustedLimit = resolvedLimit <= 0 ? Integer.MAX_VALUE : resolvedLimit;
        int resolvedMaxLimit = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{ObjectUtil.getIfNotNull(accountCookieSyncConfig, AccountCookieSyncConfig::getMaxLimit), this.maxLimit});
        int adjustedMaxLimit = resolvedMaxLimit <= 0 ? Integer.MAX_VALUE : resolvedMaxLimit;
        return cookieSyncContext.with(Math.min(adjustedLimit, adjustedMaxLimit));
    }

    private CookieSyncContext resolveBiddersToSync(CookieSyncContext cookieSyncContext) {
        ArrayList requestedBiddersAsList = new ArrayList(SetUtils.emptyIfNull(cookieSyncContext.getCookieSyncRequest().getBidders()));
        Collections.shuffle(requestedBiddersAsList);
        BiddersContext updatedContext = cookieSyncContext.getBiddersContext().toBuilder().requestedBidders(new LinkedHashSet<String>(requestedBiddersAsList)).coopSyncBidders(this.coopSyncProvider.coopSyncBidders(cookieSyncContext)).multiSyncBidders(Set.of()).build();
        return cookieSyncContext.with(updatedContext);
    }

    private CookieSyncContext filterInvalidBidders(CookieSyncContext cookieSyncContext) {
        return this.filterBidders(cookieSyncContext, bidder -> !this.bidderCatalog.isValidName((String)bidder), RejectionReason.INVALID_BIDDER);
    }

    private CookieSyncContext filterDisabledBidders(CookieSyncContext cookieSyncContext) {
        return this.filterBidders(cookieSyncContext, bidder -> !this.bidderCatalog.isActive((String)bidder), RejectionReason.DISABLED_BIDDER);
    }

    private CookieSyncContext filterBiddersWithoutUsersync(CookieSyncContext cookieSyncContext) {
        return this.filterBidders(cookieSyncContext, bidder -> this.bidderCatalog.usersyncerByName((String)bidder).isEmpty(), RejectionReason.UNCONFIGURED_USERSYNC);
    }

    private CookieSyncContext filterBiddersWithDisabledUsersync(CookieSyncContext cookieSyncContext) {
        return this.filterBidders(cookieSyncContext, bidder -> !this.bidderCatalog.usersyncerByName((String)bidder).orElseThrow().isEnabled(), RejectionReason.DISABLED_USERSYNC);
    }

    private CookieSyncContext filterInSyncBidders(CookieSyncContext cookieSyncContext) {
        return this.filterBidders(cookieSyncContext, bidder -> this.isBidderInSync(cookieSyncContext, (String)bidder), RejectionReason.ALREADY_IN_SYNC);
    }

    private boolean isBidderInSync(CookieSyncContext cookieSyncContext, String bidder) {
        String cookieFamilyName;
        RoutingContext routingContext = cookieSyncContext.getRoutingContext();
        String uidFromHostCookie = this.uidsCookieService.hostCookieUidToSync(routingContext, cookieFamilyName = this.bidderCatalog.cookieFamilyName(bidder).orElseThrow());
        return StringUtils.isEmpty((CharSequence)uidFromHostCookie) && cookieSyncContext.getUidsCookie().hasLiveUidFrom(cookieFamilyName);
    }

    private CookieSyncContext filterBidders(CookieSyncContext cookieSyncContext, Predicate<String> bidderPredicate, RejectionReason reason) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        Set<String> rejectedBidders = biddersContext.allowedBidders().stream().filter(bidderPredicate).collect(Collectors.toSet());
        BiddersContext updatedBiddersContext = biddersContext.withRejectedBidders(rejectedBidders, reason);
        return cookieSyncContext.with(updatedBiddersContext);
    }

    private CookieSyncContext applyRequestFilterSettings(CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        Set<String> allowedBidders = biddersContext.allowedBidders();
        for (String bidder : allowedBidders) {
            UsersyncMethod usersyncMethod = this.bidderCatalog.usersyncerByName(bidder).map(syncer -> cookieSyncContext.getUsersyncMethodChooser().choose((Usersyncer)syncer, bidder)).orElse(null);
            if (usersyncMethod != null) {
                biddersContext = biddersContext.withBidderUsersyncMethod(bidder, usersyncMethod);
                continue;
            }
            biddersContext = biddersContext.withRejectedBidder(bidder, RejectionReason.REJECTED_BY_FILTER);
            this.metrics.updateCookieSyncFilteredMetric(bidder);
        }
        return cookieSyncContext.with(biddersContext);
    }

    private Future<CookieSyncContext> applyPrivacyFilteringRules(CookieSyncContext cookieSyncContext) {
        TcfContext tcfContext = cookieSyncContext.getPrivacyContext().getTcfContext();
        return this.tcfDefinerService.isAllowedForHostVendorId(tcfContext).compose(hostTcfResponse -> this.filterWithTcfResponse((HostVendorTcfResponse)hostTcfResponse, cookieSyncContext)).onSuccess(updatedContext -> this.updateCookieSyncTcfMetrics(updatedContext.getBiddersContext())).otherwise(error -> (CookieSyncContext)CookieSyncService.rethrowAsCookieSyncException(error, tcfContext)).map(context -> this.filterDisallowedActivities((CookieSyncContext)context, tcfContext));
    }

    private Future<CookieSyncContext> filterWithTcfResponse(HostVendorTcfResponse hostVendorTcfResponse, CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        Set<String> allowedBidders = biddersContext.allowedBidders();
        if (!hostVendorTcfResponse.isVendorAllowed()) {
            BiddersContext rejectedContext = biddersContext.withRejectedBidders(allowedBidders, RejectionReason.REJECTED_BY_TCF);
            return Future.succeededFuture((Object)cookieSyncContext.with(rejectedContext));
        }
        CookieSyncContext updatedContext = cookieSyncContext.with(biddersContext);
        TcfContext tcfContext = updatedContext.getPrivacyContext().getTcfContext();
        AccountPrivacyConfig accountPrivacyConfig = updatedContext.getAccount().getPrivacy();
        AccountGdprConfig accountGdprConfig = accountPrivacyConfig != null ? accountPrivacyConfig.getGdpr() : null;
        return this.tcfDefinerService.resultForBidderNames(allowedBidders, tcfContext, accountGdprConfig).map(tcfResponse -> this.updateWithPrivacy((TcfResponse<String>)tcfResponse, updatedContext));
    }

    private CookieSyncContext updateWithPrivacy(TcfResponse<String> tcfResponse, CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        Set<String> allowedBidders = biddersContext.allowedBidders();
        Account account = cookieSyncContext.getAccount();
        Privacy privacy = cookieSyncContext.getPrivacyContext().getPrivacy();
        Set<String> rejectedByCcpaBidders = this.extractCcpaEnforcedBidders(account, allowedBidders, privacy);
        Map<String, PrivacyEnforcementAction> bidderToAction = tcfResponse.getActions();
        Set<String> rejectedByTcfBidders = allowedBidders.stream().filter(bidder -> !rejectedByCcpaBidders.contains(bidder)).filter(bidder -> !bidderToAction.containsKey(bidder) || ((PrivacyEnforcementAction)bidderToAction.get(bidder)).isBlockPixelSync()).collect(Collectors.toSet());
        BiddersContext privacyUpdatedBiddersContext = biddersContext.withRejectedBidders(rejectedByCcpaBidders, RejectionReason.REJECTED_BY_CCPA).withRejectedBidders(rejectedByTcfBidders, RejectionReason.REJECTED_BY_TCF);
        return cookieSyncContext.with(privacyUpdatedBiddersContext);
    }

    private Set<String> extractCcpaEnforcedBidders(Account account, Collection<String> biddersToSync, Privacy privacy) {
        if (!this.privacyEnforcementService.isCcpaEnforced(privacy.getCcpa(), account)) {
            return Collections.emptySet();
        }
        return biddersToSync.stream().filter(this::isBidderCcpaEnforced).collect(Collectors.toSet());
    }

    private boolean isBidderCcpaEnforced(String bidder) {
        BidderInfo bidderInfo = this.bidderCatalog.bidderInfoByName(bidder);
        return bidderInfo != null && bidderInfo.isCcpaEnforced();
    }

    private CookieSyncContext filterDisallowedActivities(CookieSyncContext cookieSyncContext, TcfContext tcfContext) {
        return this.filterBidders(cookieSyncContext, bidder -> !cookieSyncContext.getActivityInfrastructure().isAllowed(Activity.SYNC_USER, TcfContextActivityInvocationPayload.of(ActivityInvocationPayloadImpl.of(ComponentType.BIDDER, bidder), tcfContext)), RejectionReason.DISALLOWED_ACTIVITY);
    }

    public CookieSyncResponse prepareResponse(CookieSyncContext cookieSyncContext) {
        CookieSyncStatus cookieSyncStatus = cookieSyncContext.getUidsCookie().hasLiveUids() ? CookieSyncStatus.OK : CookieSyncStatus.NO_COOKIE;
        Set<String> biddersToSync = this.biddersToSync(cookieSyncContext);
        List statuses = ListUtils.union(this.validStatuses(biddersToSync, cookieSyncContext), this.debugStatuses(biddersToSync, cookieSyncContext));
        List<String> warnings = cookieSyncContext.getWarnings();
        List<String> resolvedWarnings = CollectionUtils.isNotEmpty(warnings) ? warnings : null;
        return CookieSyncResponse.of(cookieSyncStatus, Collections.unmodifiableList(statuses), resolvedWarnings);
    }

    private Set<String> biddersToSync(CookieSyncContext cookieSyncContext) {
        Set<String> allowedBiddersByPriority = CookieSyncService.allowedBiddersByPriority(cookieSyncContext);
        HashSet<String> cookieFamiliesToSync = new HashSet<String>();
        LinkedHashSet<String> biddersToSync = new LinkedHashSet<String>();
        Iterator<String> biddersIterator = allowedBiddersByPriority.iterator();
        while (cookieFamiliesToSync.size() < cookieSyncContext.getLimit() && biddersIterator.hasNext()) {
            String bidder = biddersIterator.next();
            String cookieFamilyName = this.bidderCatalog.cookieFamilyName(bidder).orElseThrow();
            cookieFamiliesToSync.add(cookieFamilyName);
            biddersToSync.add(bidder);
        }
        return biddersToSync;
    }

    private static Set<String> allowedBiddersByPriority(CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        LinkedHashSet<String> allowedBiddersByPriority = new LinkedHashSet<String>();
        allowedBiddersByPriority.addAll(biddersContext.allowedRequestedBidders());
        allowedBiddersByPriority.addAll(biddersContext.allowedCoopSyncBidders());
        return allowedBiddersByPriority;
    }

    private List<BidderUsersyncStatus> validStatuses(Set<String> biddersToSync, CookieSyncContext cookieSyncContext) {
        return biddersToSync.stream().filter(CookieSyncService.distinctBy(bidder -> this.bidderCatalog.cookieFamilyName((String)bidder).orElseThrow())).map(bidder -> this.validStatus((String)bidder, cookieSyncContext)).toList();
    }

    private static <T> Predicate<T> distinctBy(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return value -> seen.add(keyExtractor.apply(value));
    }

    private BidderUsersyncStatus validStatus(String bidder, CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        RoutingContext routingContext = cookieSyncContext.getRoutingContext();
        String cookieFamilyName = this.bidderCatalog.cookieFamilyName(bidder).orElseThrow();
        UsersyncMethod usersyncMethod = biddersContext.bidderUsersyncMethod().get(bidder);
        Privacy privacy = cookieSyncContext.getPrivacyContext().getPrivacy();
        String hostCookieUid = this.uidsCookieService.hostCookieUidToSync(routingContext, cookieFamilyName);
        UsersyncInfo usersyncInfo = this.toUsersyncInfo(usersyncMethod, cookieFamilyName, hostCookieUid, privacy);
        return BidderUsersyncStatus.builder().bidder(cookieFamilyName).noCookie(true).usersync(usersyncInfo).build();
    }

    private UsersyncInfo toUsersyncInfo(UsersyncMethod usersyncMethod, String cookieFamilyName, String hostCookieUid, Privacy privacy) {
        UsersyncInfoBuilder usersyncInfoBuilder = UsersyncInfoBuilder.from(usersyncMethod);
        if (hostCookieUid != null) {
            String url = "%s/setuid?bidder=%s&gdpr={{gdpr}}&gdpr_consent={{gdpr_consent}}&us_privacy={{us_privacy}}&gpp={{gpp}}&gpp_sid={{gpp_sid}}&uid=%s".formatted(this.externalUrl, HttpUtil.encodeUrl(cookieFamilyName), HttpUtil.encodeUrl(hostCookieUid));
            usersyncInfoBuilder.usersyncUrl(UsersyncUtil.enrichUrlWithFormat(url, UsersyncUtil.resolveFormat(usersyncMethod))).redirectUrl(null);
        }
        return usersyncInfoBuilder.privacy(privacy).build();
    }

    private List<BidderUsersyncStatus> debugStatuses(Set<String> biddersToSync, CookieSyncContext cookieSyncContext) {
        if (!cookieSyncContext.isDebug()) {
            return Collections.emptyList();
        }
        ArrayList<BidderUsersyncStatus> debugStatuses = new ArrayList<BidderUsersyncStatus>();
        debugStatuses.addAll(this.rejectionStatuses(cookieSyncContext));
        debugStatuses.addAll(this.limitStatuses(biddersToSync, cookieSyncContext));
        debugStatuses.addAll(this.aliasSyncedAsRootStatuses(biddersToSync, cookieSyncContext));
        return debugStatuses;
    }

    private List<BidderUsersyncStatus> rejectionStatuses(CookieSyncContext cookieSyncContext) {
        BiddersContext biddersContext = cookieSyncContext.getBiddersContext();
        return biddersContext.rejectedBidders().entrySet().stream().map(bidderWithReason -> this.rejectionStatus((String)bidderWithReason.getKey(), (RejectionReason)((Object)((Object)bidderWithReason.getValue())), biddersContext)).filter(BidderUsersyncStatus::isError).toList();
    }

    private BidderUsersyncStatus rejectionStatus(String bidder, RejectionReason reason, BiddersContext biddersContext) {
        String cookieFamilyName = this.bidderCatalog.cookieFamilyName(bidder).orElse(bidder);
        BidderUsersyncStatus.BidderUsersyncStatusBuilder builder = BidderUsersyncStatus.builder().bidder(cookieFamilyName);
        boolean requested = biddersContext.isRequested(bidder);
        boolean coopSync = biddersContext.isCoopSync(bidder);
        builder = switch (reason) {
            default -> throw new IncompatibleClassChangeError();
            case RejectionReason.INVALID_BIDDER -> builder.conditionalError(requested, "Unsupported bidder");
            case RejectionReason.DISABLED_BIDDER -> builder.conditionalError(requested, "Disabled bidder");
            case RejectionReason.REJECTED_BY_TCF -> builder.conditionalError(requested || coopSync, "Rejected by TCF");
            case RejectionReason.REJECTED_BY_CCPA -> builder.conditionalError(requested || coopSync, "Rejected by CCPA");
            case RejectionReason.DISALLOWED_ACTIVITY -> builder.conditionalError(requested || coopSync, "Disallowed activity");
            case RejectionReason.UNCONFIGURED_USERSYNC -> builder.conditionalError(requested, "No sync config");
            case RejectionReason.DISABLED_USERSYNC -> builder.conditionalError(requested || coopSync, "Sync disabled by config");
            case RejectionReason.REJECTED_BY_FILTER -> builder.conditionalError(requested || coopSync, "Rejected by request filter");
            case RejectionReason.ALREADY_IN_SYNC -> builder.conditionalError(requested, "Already in sync");
        };
        return builder.build();
    }

    private List<BidderUsersyncStatus> limitStatuses(Set<String> biddersToSync, CookieSyncContext cookieSyncContext) {
        SetUtils.SetView droppedDueToLimitBidders = SetUtils.difference(cookieSyncContext.getBiddersContext().allowedRequestedBidders(), biddersToSync);
        return droppedDueToLimitBidders.stream().map(bidder -> BidderUsersyncStatus.builder().bidder(this.bidderCatalog.cookieFamilyName((String)bidder).orElseThrow()).error("limit reached").build()).toList();
    }

    private List<BidderUsersyncStatus> aliasSyncedAsRootStatuses(Set<String> biddersToSync, CookieSyncContext cookieSyncContext) {
        Set<String> allowedRequestedBidders = cookieSyncContext.getBiddersContext().allowedRequestedBidders();
        return biddersToSync.stream().filter(bidder -> allowedRequestedBidders.contains(bidder)).filter(this::isAliasSyncedAsRootFamily).map(this::warningForAliasSyncedAsRootFamily).toList();
    }

    private boolean isAliasSyncedAsRootFamily(String bidder) {
        return this.bidderCatalog.isAlias(bidder) && this.bidderCatalog.usersyncerByName(bidder).map(Usersyncer::getCookieFamilySource).filter(source -> source == CookieFamilySource.ROOT).isPresent();
    }

    private BidderUsersyncStatus warningForAliasSyncedAsRootFamily(String bidder) {
        String cookieFamilyName = this.bidderCatalog.cookieFamilyName(bidder).orElseThrow();
        return BidderUsersyncStatus.builder().bidder(bidder).error("synced as " + cookieFamilyName).build();
    }

    private void updateCookieSyncTcfMetrics(BiddersContext biddersContext) {
        biddersContext.rejectedBidders().entrySet().stream().filter(entry -> entry.getValue() == RejectionReason.REJECTED_BY_TCF).map(Map.Entry::getKey).forEach(bidder -> this.metrics.updateCookieSyncTcfBlockedMetric(this.bidderCatalog.isValidName((String)bidder) ? bidder : "unknown"));
    }

    private static <T> T rethrowAsCookieSyncException(Throwable error, TcfContext tcfContext) {
        throw new CookieSyncException(error, tcfContext);
    }
}

