/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.videoheroes;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.videoheroes.ExtImpVideoHeroes;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class VideoHeroesBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpVideoHeroes>> VIDEO_HEROES_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpVideoHeroes>>(){};
    private static final String URL_PUBLISHER_ID_MACRO = "{{PublisherID}}";
    private static final int FIRST_IMP_INDEX = 0;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public VideoHeroesBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpVideoHeroes impExt;
        List<Imp> requestImps = request.getImp();
        Imp firstImp = requestImps.get(0);
        try {
            impExt = this.parseImpExt(firstImp);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(this.createRequest(VideoHeroesBidder.modifyFirstImp(requestImps), request, impExt));
    }

    private static List<Imp> modifyFirstImp(List<Imp> imp) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>(imp);
        Imp modifiedFirstImp = imp.get(0).toBuilder().ext(null).build();
        modifiedImps.set(0, modifiedFirstImp);
        return modifiedImps;
    }

    private ExtImpVideoHeroes parseImpExt(Imp imp) {
        try {
            return (ExtImpVideoHeroes)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), VIDEO_HEROES_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private String resolveEndpoint(String publisherId) {
        return this.endpointUrl.replace(URL_PUBLISHER_ID_MACRO, HttpUtil.encodeUrl(publisherId));
    }

    private HttpRequest<BidRequest> createRequest(List<Imp> imp, BidRequest request, ExtImpVideoHeroes extImpVideoHeroes) {
        BidRequest outgoingRequest = request.toBuilder().imp(imp).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.resolveEndpoint(extImpVideoHeroes.getPlacementId()), this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(VideoHeroesBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, VideoHeroesBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        return BidType.banner;
    }
}

