/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.smartadserver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.smartadserver.ExtImpSmartadserver;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class SmartadserverBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpSmartadserver>> SMARTADSERVER_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpSmartadserver>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public SmartadserverBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> result = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpSmartadserver extImpSmartadserver = this.parseImpExt(imp);
                BidRequest updatedRequest = request.toBuilder().imp(Collections.singletonList(imp)).site(SmartadserverBidder.modifySite(request.getSite(), extImpSmartadserver.getNetworkId())).build();
                result.add(this.createSingleRequest(updatedRequest));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(result, errors);
    }

    private ExtImpSmartadserver parseImpExt(Imp imp) {
        try {
            return (ExtImpSmartadserver)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), SMARTADSERVER_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error parsing smartadserverExt parameters");
        }
    }

    private HttpRequest<BidRequest> createSingleRequest(BidRequest request) {
        return BidderUtil.defaultRequest(request, this.getUri(), this.mapper);
    }

    private String getUri() {
        URI uri;
        try {
            uri = new URI(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Malformed URL: %s.".formatted(this.endpointUrl));
        }
        return new URIBuilder(uri).setPath(StringUtils.removeEnd((String)uri.getPath(), (String)"/") + "/api/bid").addParameter("callerId", "5").toString();
    }

    private static Site modifySite(Site site, Integer networkId) {
        Site.SiteBuilder siteBuilder = site != null ? site.toBuilder() : Site.builder();
        Publisher sitePublisher = site != null ? site.getPublisher() : null;
        return siteBuilder.publisher(SmartadserverBidder.modifyPublisher(sitePublisher, networkId)).build();
    }

    private static Publisher modifyPublisher(Publisher publisher, Integer networkId) {
        Publisher.PublisherBuilder publisherBuilder = publisher != null ? publisher.toBuilder() : Publisher.builder();
        return publisherBuilder.id(String.valueOf(networkId)).build();
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return this.extractBids(httpCall.getRequest().getPayload(), bidResponse);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, SmartadserverBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
        return Result.of(bidderBids, errors);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            return imp.getVideo() != null ? BidType.video : (imp.getXNative() != null ? BidType.xNative : BidType.banner);
        }
        return BidType.banner;
    }
}

