/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.rtbhouse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.rtbhouse.ExtImpRtbhouse;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class RtbhouseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpRtbhouse>> RTBHOUSE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpRtbhouse>>(){};
    private static final String BIDDER_CURRENCY = "USD";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final CurrencyConversionService currencyConversionService;

    public RtbhouseBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpRtbhouse impExt = this.parseImpExt(imp);
                Price bidFloorPrice = this.resolveBidFloor(imp, impExt, bidRequest);
                modifiedImps.add(RtbhouseBidder.modifyImp(imp, bidFloorPrice));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (errors.size() > 0) {
            return Result.withErrors(errors);
        }
        BidRequest outgoingRequest = bidRequest.toBuilder().cur(Collections.singletonList(BIDDER_CURRENCY)).imp(modifiedImps).build();
        return Result.withValue(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper));
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> bidderErrors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(bidRequest, bidResponse, bidderErrors));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> bidderErrors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid((Bid)bid, bidRequest, bidResponse, bidderErrors)).toList();
    }

    private BidderBid resolveBidderBid(Bid bid, BidRequest bidRequest, BidResponse bidResponse, List<BidderError> bidderErrors) {
        String currency = bidResponse.getCur();
        BidType bidType = RtbhouseBidder.getBidType(bid.getImpid(), bidRequest.getImp());
        String bidAdm = bid.getAdm();
        String resolvedAdm = bidAdm != null && bidType == BidType.xNative ? this.resolveNativeAdm(bidAdm, bidderErrors) : bidAdm;
        Bid updatedBid = bid.toBuilder().adm(resolvedAdm).build();
        return BidderBid.builder().bid(updatedBid).type(bidType).bidCurrency(currency).build();
    }

    private String resolveNativeAdm(String adm, List<BidderError> bidderErrors) {
        JsonNode admNode;
        try {
            admNode = this.mapper.mapper().readTree(adm);
        }
        catch (JsonProcessingException e) {
            bidderErrors.add(BidderError.badServerResponse("Unable to parse native adm: %s".formatted(adm)));
            return null;
        }
        JsonNode nativeNode = admNode.get("native");
        if (nativeNode != null) {
            return nativeNode.toString();
        }
        return adm;
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        return BidType.banner;
    }

    private ExtImpRtbhouse parseImpExt(Imp imp) {
        try {
            return (ExtImpRtbhouse)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), RTBHOUSE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static Imp modifyImp(Imp imp, Price bidFloorPrice) {
        return imp.toBuilder().bidfloorcur(ObjectUtil.getIfNotNull(bidFloorPrice, Price::getCurrency)).bidfloor(ObjectUtil.getIfNotNull(bidFloorPrice, Price::getValue)).build();
    }

    private Price resolveBidFloor(Imp imp, ExtImpRtbhouse impExt, BidRequest bidRequest) {
        List<String> brCur = bidRequest.getCur();
        Price initialBidFloorPrice = Price.of(imp.getBidfloorcur(), imp.getBidfloor());
        BigDecimal impExtBidFloor = impExt.getBidFloor();
        String impExtCurrency = impExtBidFloor != null && brCur != null && brCur.size() > 0 ? brCur.get(0) : null;
        Price impExtBidFloorPrice = Price.of(impExtCurrency, impExtBidFloor);
        Price resolvedPrice = initialBidFloorPrice.getValue() == null ? impExtBidFloorPrice : initialBidFloorPrice;
        return BidderUtil.isValidPrice(resolvedPrice) && !StringUtils.equalsIgnoreCase((CharSequence)resolvedPrice.getCurrency(), (CharSequence)BIDDER_CURRENCY) ? this.convertBidFloor(resolvedPrice, imp.getId(), bidRequest) : resolvedPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, BIDDER_CURRENCY);
            return Price.of(BIDDER_CURRENCY, convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException(String.format("Unable to convert provided bid floor currency from %s to %s for imp `%s`", bidFloorCur, BIDDER_CURRENCY, impId));
        }
    }
}

