/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.rise;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.rise.ExtImpRise;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class RiseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpRise>> RISE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpRise>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public RiseBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        String impExt;
        try {
            impExt = this.findImpExtValidValue(bidRequest.getImp());
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(BidderUtil.defaultRequest(bidRequest, this.resolveUrl(impExt), this.mapper));
    }

    private String findImpExtValidValue(List<Imp> imps) {
        for (Imp imp : imps) {
            ExtImpRise extImpRise = this.parseImpExt(imp);
            String org = extImpRise.getOrg();
            if (StringUtils.isNotBlank((CharSequence)org)) {
                return org.trim();
            }
            String publisherId = extImpRise.getPublisherId();
            if (!StringUtils.isNotBlank((CharSequence)publisherId)) continue;
            return publisherId.trim();
        }
        throw new PreBidException("No org or publisher_id supplied");
    }

    private ExtImpRise parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpRise)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), RISE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private String resolveUrl(String publisherId) {
        return this.endpointUrl + "?publisher_id=" + publisherId;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bids = RiseBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors);
        return Result.of(bids, errors);
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> RiseBidder.makeBidderBid(bid, bidRequest.getImp(), bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, RiseBidder.resolveBidType(bid), currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private static BidType resolveBidType(Bid bid) throws PreBidException {
        Integer markupType = bid.getMtype();
        if (markupType == null) {
            throw new PreBidException("Missing MType for bid: " + bid.getId());
        }
        return switch (markupType) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            default -> throw new PreBidException("Unsupported MType: %s, for bid: %s".formatted(markupType, bid.getId()));
        };
    }
}

