/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.revcontent;

import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class RevcontentBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public RevcontentBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        try {
            RevcontentBidder.validateRequest(bidRequest);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(BidderUtil.defaultRequest(bidRequest, this.endpointUrl, this.mapper));
    }

    private static void validateRequest(BidRequest bidRequest) throws PreBidException {
        if (StringUtils.isBlank((CharSequence)ObjectUtil.getIfNotNull(bidRequest.getApp(), App::getName)) && StringUtils.isBlank((CharSequence)ObjectUtil.getIfNotNull(bidRequest.getSite(), Site::getDomain))) {
            throw new PreBidException("Impression is missing app name or site domain, and must contain one.");
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(RevcontentBidder.extractBids(bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        String currency = bidResponse.getCur();
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, RevcontentBidder.resolveBidType(bid), currency)).toList();
    }

    private static BidType resolveBidType(Bid bid) {
        String bidAdm = bid.getAdm();
        return StringUtils.isNotBlank((CharSequence)bidAdm) && bidAdm.charAt(0) == '<' ? BidType.banner : BidType.xNative;
    }
}

