/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.pulsepoint;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.pulsepoint.ExtImpPulsepoint;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class PulsepointBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpPulsepoint>> PULSEPOINT_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpPulsepoint>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public PulsepointBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        String publisherId = null;
        for (Imp imp : bidRequest.getImp()) {
            ExtImpPulsepoint extImpPulsepoint;
            try {
                extImpPulsepoint = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
                continue;
            }
            modifiedImps.add(PulsepointBidder.modifyImp(imp, extImpPulsepoint));
            Integer extPublisherId = extImpPulsepoint.getPublisherId();
            if (publisherId != null || extPublisherId == null || extPublisherId <= 0) continue;
            publisherId = extPublisherId.toString();
        }
        if (modifiedImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        publisherId = StringUtils.defaultString(publisherId);
        BidRequest modifiedRequest = PulsepointBidder.modifyRequest(bidRequest, publisherId, modifiedImps);
        return Result.of(Collections.singletonList(this.createHttpRequest(modifiedRequest)), errors);
    }

    private ExtImpPulsepoint parseImpExt(Imp imp) {
        try {
            return (ExtImpPulsepoint)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), PULSEPOINT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static Imp modifyImp(Imp imp, ExtImpPulsepoint extImpPulsepoint) {
        return imp.toBuilder().tagid(extImpPulsepoint.getTagId().toString()).build();
    }

    private static BidRequest modifyRequest(BidRequest request, String publisherId, List<Imp> imps) {
        return request.toBuilder().site(PulsepointBidder.modifySite(request.getSite(), publisherId)).app(PulsepointBidder.modifyApp(request.getApp(), publisherId)).imp(imps).build();
    }

    private static Site modifySite(Site site, String publisherId) {
        return site != null ? site.toBuilder().publisher(PulsepointBidder.modifyPublisher(site.getPublisher(), publisherId)).build() : null;
    }

    private static App modifyApp(App app, String publisherId) {
        return app != null ? app.toBuilder().publisher(PulsepointBidder.modifyPublisher(app.getPublisher(), publisherId)).build() : null;
    }

    private static Publisher modifyPublisher(Publisher publisher, String publisherId) {
        return publisher != null ? publisher.toBuilder().id(publisherId).build() : Publisher.builder().id(publisherId).build();
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest request) {
        return BidderUtil.defaultRequest(request, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(PulsepointBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> PulsepointBidder.makeBidderBid(bid, bidRequest.getImp(), bidResponse.getCur())).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency) {
        BidType bidType = PulsepointBidder.resolveBidType(bid.getImpid(), imps);
        return bidType != null ? BidderBid.of(bid, bidType, currency) : null;
    }

    private static BidType resolveBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!Objects.equals(impId, imp.getId())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getAudio() != null) {
                return BidType.audio;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        return null;
    }
}

