/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.pubmatic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.CompositeBidderResponse;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticBidderImpExt;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticExtData;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticExtDataAdServer;
import org.prebid.server.bidder.pubmatic.model.request.PubmaticWrapper;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticBidExt;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticBidResponse;
import org.prebid.server.bidder.pubmatic.model.response.PubmaticExtBidResponse;
import org.prebid.server.bidder.pubmatic.model.response.VideoCreativeInfo;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.pubmatic.ExtImpPubmatic;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.proto.openrtb.ext.response.FledgeAuctionConfig;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class PubmaticBidder
implements Bidder<BidRequest> {
    private static final String DCTR_KEY_NAME = "key_val";
    private static final String PM_ZONE_ID_KEY_NAME = "pmZoneId";
    private static final String PM_ZONE_ID_OLD_KEY_NAME = "pmZoneID";
    private static final String IMP_EXT_AD_UNIT_KEY = "dfp_ad_unit_code";
    private static final String AD_SERVER_GAM = "gam";
    private static final String PREBID = "prebid";
    private static final String ACAT_EXT_REQUEST = "acat";
    private static final String WRAPPER_EXT_REQUEST = "wrapper";
    private static final String BIDDER_NAME = "pubmatic";
    private static final String AE = "ae";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public PubmaticBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        PubmaticWrapper wrapper;
        List<String> acat;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        String publisherId = null;
        try {
            acat = this.extractAcat(request);
            wrapper = this.extractWrapper(request);
        }
        catch (IllegalArgumentException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        for (Imp imp : request.getImp()) {
            try {
                PubmaticBidder.validateMediaType(imp);
                PubmaticBidderImpExt impExt = this.parseImpExt(imp);
                ExtImpPubmatic extImpPubmatic = impExt.getBidder();
                publisherId = (String)ObjectUtils.defaultIfNull(publisherId, (Object)StringUtils.trimToNull((String)extImpPubmatic.getPublisherId()));
                wrapper = PubmaticBidder.merge(wrapper, extImpPubmatic.getWrapper());
                validImps.add(this.modifyImp(imp, impExt));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (validImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest modifiedBidRequest = this.modifyBidRequest(request, validImps, publisherId, wrapper, acat);
        return Result.of(Collections.singletonList(this.makeHttpRequest(modifiedBidRequest)), errors);
    }

    private List<String> extractAcat(BidRequest request) {
        JsonNode bidderParams = PubmaticBidder.getExtRequestPrebidBidderparams(request);
        JsonNode acatNode = bidderParams != null ? bidderParams.get(ACAT_EXT_REQUEST) : null;
        return acatNode != null && acatNode.isArray() ? Arrays.stream((String[])this.mapper.mapper().convertValue((Object)acatNode, String[].class)).map(StringUtils::stripToEmpty).toList() : null;
    }

    private PubmaticWrapper extractWrapper(BidRequest request) {
        JsonNode pubmatic = PubmaticBidder.getExtRequestPrebidBidderparams(request);
        JsonNode wrapperNode = pubmatic != null ? pubmatic.get(WRAPPER_EXT_REQUEST) : null;
        return wrapperNode != null && wrapperNode.isObject() ? (PubmaticWrapper)this.mapper.mapper().convertValue((Object)wrapperNode, PubmaticWrapper.class) : null;
    }

    private static JsonNode getExtRequestPrebidBidderparams(BidRequest request) {
        ExtRequest extRequest = request.getExt();
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ObjectNode bidderParams = extRequestPrebid != null ? extRequestPrebid.getBidderparams() : null;
        return bidderParams != null ? bidderParams.get(BIDDER_NAME) : null;
    }

    private static void validateMediaType(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null && imp.getXNative() == null) {
            throw new PreBidException("Invalid MediaType. PubMatic only supports Banner, Video and Native. Ignoring ImpID=%s".formatted(imp.getId()));
        }
    }

    private static PubmaticWrapper merge(PubmaticWrapper left, PubmaticWrapper right) {
        if (Objects.equals(left, right) || PubmaticBidder.isWrapperValid(left)) {
            return left;
        }
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        return PubmaticWrapper.of((Integer)ObjectUtils.defaultIfNull((Object)PubmaticBidder.stripToNull(left.getProfile()), (Object)right.getProfile()), (Integer)ObjectUtils.defaultIfNull((Object)PubmaticBidder.stripToNull(left.getVersion()), (Object)right.getVersion()));
    }

    private static boolean isWrapperValid(PubmaticWrapper wrapper) {
        return wrapper != null && PubmaticBidder.stripToNull(wrapper.getProfile()) != null && PubmaticBidder.stripToNull(wrapper.getVersion()) != null;
    }

    private static Integer stripToNull(Integer value) {
        return value == null || value == 0 ? null : value;
    }

    private PubmaticBidderImpExt parseImpExt(Imp imp) {
        try {
            return (PubmaticBidderImpExt)this.mapper.mapper().convertValue((Object)imp.getExt(), PubmaticBidderImpExt.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, PubmaticBidderImpExt impExt) {
        Banner banner = imp.getBanner();
        ExtImpPubmatic impExtBidder = impExt.getBidder();
        ObjectNode modifiedExt = this.makeKeywords(impExt);
        if (impExt.getAe() != null) {
            modifiedExt.put(AE, impExt.getAe());
        }
        Imp.ImpBuilder impBuilder = imp.toBuilder().banner(banner != null ? PubmaticBidder.assignSizesIfMissing(banner) : null).ext((ObjectNode)(!modifiedExt.isEmpty() ? modifiedExt : null)).bidfloor(this.resolveBidFloor(impExtBidder.getKadfloor(), imp.getBidfloor())).audio(null);
        return PubmaticBidder.enrichWithAdSlotParameters(impBuilder, impExtBidder.getAdSlot(), banner).build();
    }

    private BigDecimal resolveBidFloor(String kadfloor, BigDecimal existingFloor) {
        BigDecimal kadFloor = PubmaticBidder.parseKadFloor(kadfloor);
        return ObjectUtils.allNotNull((Object[])new Object[]{kadFloor, existingFloor}) ? kadFloor.max(existingFloor) : (BigDecimal)ObjectUtils.firstNonNull((Object[])new BigDecimal[]{kadFloor, existingFloor});
    }

    private static BigDecimal parseKadFloor(String kadFloorString) {
        try {
            return new BigDecimal(StringUtils.trimToEmpty((String)kadFloorString));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Imp.ImpBuilder enrichWithAdSlotParameters(Imp.ImpBuilder impBuilder, String adSlot, Banner banner) {
        String trimmedAdSlot = StringUtils.trimToNull((String)adSlot);
        if (StringUtils.isEmpty((CharSequence)trimmedAdSlot)) {
            return impBuilder;
        }
        if (!trimmedAdSlot.contains("@")) {
            impBuilder.tagid(trimmedAdSlot);
            return impBuilder;
        }
        String[] adSlotParams = trimmedAdSlot.split("@");
        if (adSlotParams.length != 2 || StringUtils.isEmpty((CharSequence)adSlotParams[0].trim()) || StringUtils.isEmpty((CharSequence)adSlotParams[1].trim())) {
            throw new PreBidException("Invalid adSlot '%s'".formatted(trimmedAdSlot));
        }
        impBuilder.tagid(adSlotParams[0]);
        String[] adSize = adSlotParams[1].toLowerCase().split("x");
        if (adSize.length != 2) {
            throw new PreBidException("Invalid size provided in adSlot '%s'".formatted(trimmedAdSlot));
        }
        Integer width = PubmaticBidder.parseAdSizeParam(adSize[0], "width", adSlot);
        String[] heightParams = adSize[1].split(":");
        Integer height = PubmaticBidder.parseAdSizeParam(heightParams[0], "height", adSlot);
        return impBuilder.banner(PubmaticBidder.modifyWithSizeParams(banner, width, height));
    }

    private static Integer parseAdSizeParam(String number, String paramName, String adSlot) {
        try {
            return Integer.parseInt(number.trim());
        }
        catch (NumberFormatException e) {
            throw new PreBidException("Invalid %s provided in adSlot '%s'".formatted(paramName, adSlot));
        }
    }

    private static Banner modifyWithSizeParams(Banner banner, Integer width, Integer height) {
        return banner != null ? banner.toBuilder().w(width).h(height).build() : null;
    }

    private static Banner assignSizesIfMissing(Banner banner) {
        List<Format> format = banner.getFormat();
        if (banner.getW() != null && banner.getH() != null || CollectionUtils.isEmpty(format)) {
            return banner;
        }
        Format firstFormat = format.get(0);
        return PubmaticBidder.modifyWithSizeParams(banner, firstFormat.getW(), firstFormat.getH());
    }

    private ObjectNode makeKeywords(PubmaticBidderImpExt impExt) {
        ObjectNode keywordsNode = this.mapper.mapper().createObjectNode();
        PubmaticBidder.putExtBidderKeywords(keywordsNode, impExt.getBidder());
        PubmaticExtData pubmaticExtData = impExt.getData();
        if (pubmaticExtData != null) {
            PubmaticBidder.putExtDataKeywords(keywordsNode, pubmaticExtData);
        }
        return keywordsNode;
    }

    private static void putExtBidderKeywords(ObjectNode keywords, ExtImpPubmatic extBidder) {
        CollectionUtils.emptyIfNull(extBidder.getKeywords()).forEach(keyword -> {
            if (CollectionUtils.isEmpty(keyword.getValue())) {
                return;
            }
            keywords.put(keyword.getKey(), String.join((CharSequence)",", keyword.getValue()));
        });
        JsonNode pmZoneIdKeyWords = keywords.remove(PM_ZONE_ID_OLD_KEY_NAME);
        String pmZomeId = extBidder.getPmZoneId();
        if (StringUtils.isNotEmpty((CharSequence)pmZomeId)) {
            keywords.put(PM_ZONE_ID_KEY_NAME, extBidder.getPmZoneId());
        } else if (pmZoneIdKeyWords != null) {
            keywords.set(PM_ZONE_ID_KEY_NAME, pmZoneIdKeyWords);
        }
        String dctr = extBidder.getDctr();
        if (StringUtils.isNotEmpty((CharSequence)dctr)) {
            keywords.put(DCTR_KEY_NAME, dctr);
        }
    }

    private static void putExtDataKeywords(ObjectNode keywords, PubmaticExtData extData) {
        String adSeverAdSlot;
        String pbaAdSlot = extData.getPbAdSlot();
        PubmaticExtDataAdServer extAdServer = extData.getAdServer();
        String adSeverName = extAdServer != null ? extAdServer.getName() : null;
        String string = adSeverAdSlot = extAdServer != null ? extAdServer.getAdSlot() : null;
        if (AD_SERVER_GAM.equals(adSeverName) && StringUtils.isNotEmpty((CharSequence)adSeverAdSlot)) {
            keywords.put(IMP_EXT_AD_UNIT_KEY, adSeverAdSlot);
        } else if (StringUtils.isNotEmpty((CharSequence)pbaAdSlot)) {
            keywords.put(IMP_EXT_AD_UNIT_KEY, pbaAdSlot);
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request) {
        return BidderUtil.defaultRequest(request, this.endpointUrl, this.mapper);
    }

    private BidRequest modifyBidRequest(BidRequest request, List<Imp> imps, String publisherId, PubmaticWrapper wrapper, List<String> acat) {
        return request.toBuilder().imp(imps).app(PubmaticBidder.modifyApp(request.getApp(), publisherId)).site(PubmaticBidder.modifySite(request.getSite(), publisherId)).ext(this.modifyExtRequest(request.getExt(), wrapper, acat)).build();
    }

    private ExtRequest modifyExtRequest(ExtRequest extRequest, PubmaticWrapper wrapper, List<String> acat) {
        ObjectNode extNode = this.mapper.mapper().createObjectNode();
        if (wrapper != null) {
            extNode.set(WRAPPER_EXT_REQUEST, this.mapper.mapper().valueToTree((Object)wrapper));
        }
        if (CollectionUtils.isNotEmpty(acat)) {
            extNode.set(ACAT_EXT_REQUEST, this.mapper.mapper().valueToTree(acat));
        }
        return extNode.isEmpty() ? extRequest : this.mapper.fillExtension(ExtRequest.empty(), extNode);
    }

    private static Site modifySite(Site site, String publisherId) {
        return publisherId != null && site != null ? site.toBuilder().publisher(PubmaticBidder.modifyPublisher(site.getPublisher(), publisherId)).build() : site;
    }

    private static App modifyApp(App app, String publisherId) {
        return publisherId != null && app != null ? app.toBuilder().publisher(PubmaticBidder.modifyPublisher(app.getPublisher(), publisherId)).build() : app;
    }

    private static Publisher modifyPublisher(Publisher publisher, String publisherId) {
        return publisher != null ? publisher.toBuilder().id(publisherId).build() : Publisher.builder().id(publisherId).build();
    }

    @Override
    @Deprecated(forRemoval=true)
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        return Result.withError(BidderError.generic("Deprecated adapter method invoked"));
    }

    @Override
    public CompositeBidderResponse makeBidderResponse(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> bidderErrors = new ArrayList<BidderError>();
            PubmaticBidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), PubmaticBidResponse.class);
            return CompositeBidderResponse.withBids(this.extractBids(bidResponse, bidderErrors), PubmaticBidder.extractFledge(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return CompositeBidderResponse.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(PubmaticBidResponse bidResponse, List<BidderError> bidderErrors) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse, bidderErrors);
    }

    private List<BidderBid> bidsFromResponse(PubmaticBidResponse bidResponse, List<BidderError> bidderErrors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.resolveBidderBid((Bid)bid, bidResponse.getCur(), bidderErrors)).toList();
    }

    private BidderBid resolveBidderBid(Bid bid, String currency, List<BidderError> bidderErrors) {
        String resolvedAdm;
        List singleElementBidCat = CollectionUtils.emptyIfNull(bid.getCat()).stream().limit(1L).collect(Collectors.collectingAndThen(Collectors.toList(), bidCat -> !bidCat.isEmpty() ? bidCat : null));
        PubmaticBidExt pubmaticBidExt = this.extractBidExt(bid.getExt());
        Integer duration = PubmaticBidder.getDuration(pubmaticBidExt);
        BidType bidType = PubmaticBidder.getBidType(pubmaticBidExt);
        String bidAdm = bid.getAdm();
        String string = resolvedAdm = bidAdm != null && bidType == BidType.xNative ? this.resolveNativeAdm(bidAdm, bidderErrors) : bidAdm;
        Bid updatedBid = singleElementBidCat != null || duration != null || resolvedAdm != null ? bid.toBuilder().adm(resolvedAdm != null ? resolvedAdm : bidAdm).cat(singleElementBidCat).ext(duration != null ? this.updateBidExtWithExtPrebid(duration, bid.getExt()) : bid.getExt()).build() : bid;
        return BidderBid.builder().bid(updatedBid).type(bidType).bidCurrency(currency).dealPriority(PubmaticBidder.getDealPriority(pubmaticBidExt)).build();
    }

    private PubmaticBidExt extractBidExt(ObjectNode bidExt) {
        try {
            return bidExt != null ? (PubmaticBidExt)this.mapper.mapper().treeToValue((TreeNode)bidExt, PubmaticBidExt.class) : null;
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private static BidType getBidType(PubmaticBidExt bidExt) {
        Integer bidType = bidExt != null ? (Integer)ObjectUtils.defaultIfNull((Object)bidExt.getBidType(), (Object)0) : Integer.valueOf(0);
        return switch (bidType) {
            case 1 -> BidType.video;
            case 2 -> BidType.xNative;
            default -> BidType.banner;
        };
    }

    private String resolveNativeAdm(String adm, List<BidderError> bidderErrors) {
        JsonNode admNode;
        try {
            admNode = this.mapper.mapper().readTree(adm);
        }
        catch (JsonProcessingException e) {
            bidderErrors.add(BidderError.badServerResponse("Unable to parse native adm: %s".formatted(adm)));
            return null;
        }
        JsonNode nativeNode = admNode.get("native");
        if (!nativeNode.isMissingNode()) {
            return nativeNode.toString();
        }
        return null;
    }

    private static Integer getDuration(PubmaticBidExt bidExt) {
        VideoCreativeInfo creativeInfo = bidExt != null ? bidExt.getVideo() : null;
        return creativeInfo != null ? creativeInfo.getDuration() : null;
    }

    private ObjectNode updateBidExtWithExtPrebid(Integer duration, ObjectNode extBid) {
        ExtBidPrebid extBidPrebid = ExtBidPrebid.builder().video(ExtBidPrebidVideo.of(duration, null)).build();
        return (ObjectNode)extBid.set(PREBID, this.mapper.mapper().valueToTree((Object)extBidPrebid));
    }

    private static Integer getDealPriority(PubmaticBidExt bidExt) {
        return Optional.ofNullable(bidExt).map(PubmaticBidExt::getPrebidDealPriority).orElse(null);
    }

    private static List<FledgeAuctionConfig> extractFledge(PubmaticBidResponse bidResponse) {
        return Optional.ofNullable(bidResponse).map(PubmaticBidResponse::getExt).map(PubmaticExtBidResponse::getFledgeAuctionConfigs).orElse(Collections.emptyMap()).entrySet().stream().map(e -> FledgeAuctionConfig.builder().impId((String)e.getKey()).config((ObjectNode)e.getValue()).build()).toList();
    }
}

