/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.onetag;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.onetag.ExtImpOnetag;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class OnetagBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpOnetag>> ONETAG_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpOnetag>>(){};
    private static final String URL_PUBLISHER_ID_MACRO = "{{publisherId}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public OnetagBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        String requestPubId = null;
        for (Imp imp : request.getImp()) {
            try {
                ExtImpOnetag impExt = this.parseImpExt(imp);
                requestPubId = this.resolveAndValidatePubId(impExt.getPubId(), requestPubId);
                modifiedImps.add(imp.toBuilder().ext(impExt.getExt()).build());
            }
            catch (PreBidException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.withValue(this.createRequest(request, modifiedImps, requestPubId));
    }

    private ExtImpOnetag parseImpExt(Imp imp) {
        try {
            return (ExtImpOnetag)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ONETAG_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private String resolveAndValidatePubId(String impExtPubId, String requestPubId) {
        if (StringUtils.isEmpty((CharSequence)impExtPubId)) {
            throw new PreBidException("The publisher ID must not be empty");
        }
        if (requestPubId != null && !impExtPubId.equals(requestPubId)) {
            throw new PreBidException("There must be only one publisher ID");
        }
        return impExtPubId;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, List<Imp> imps, String pubId) {
        String url = this.endpointUrl.replace(URL_PUBLISHER_ID_MACRO, pubId);
        BidRequest outgoingRequest = request.toBuilder().imp(imps).build();
        return BidderUtil.defaultRequest(outgoingRequest, url, this.mapper);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(OnetagBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return OnetagBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, OnetagBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("The impression with ID %s is not present into the request".formatted(impId));
    }
}

