/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.prebid.server.bidder.model.BidderError;

public final class Result<T> {
    private final T value;
    private final List<BidderError> errors;

    public static <R> Result<List<R>> withValues(List<R> values) {
        return Result.of(values, Collections.emptyList());
    }

    public static <R> Result<List<R>> withValue(R value) {
        return Result.of(Collections.singletonList(value), Collections.emptyList());
    }

    public static <R> Result<List<R>> withErrors(List<BidderError> errors) {
        return Result.of(Collections.emptyList(), errors);
    }

    public static <R> Result<List<R>> withError(BidderError error) {
        return Result.of(Collections.emptyList(), Collections.singletonList(error));
    }

    public static <R> Result<List<R>> empty() {
        return Result.of(Collections.emptyList(), Collections.emptyList());
    }

    public T getValue() {
        return this.value;
    }

    public List<BidderError> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<BidderError> this$errors = this.getErrors();
        List<BidderError> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<BidderError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "Result(value=" + this.getValue() + ", errors=" + this.getErrors() + ")";
    }

    @ConstructorProperties(value={"value", "errors"})
    private Result(T value, List<BidderError> errors) {
        this.value = value;
        this.errors = errors;
    }

    public static <T> Result<T> of(T value, List<BidderError> errors) {
        return new Result<T>(value, errors);
    }
}

