/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.model;

import com.iab.openrtb.response.Bid;
import java.beans.ConstructorProperties;
import org.prebid.server.bidder.model.PriceFloorInfo;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;

public final class BidderBid {
    private final Bid bid;
    private final BidType type;
    private final String bidCurrency;
    private final Integer dealPriority;
    private final ExtBidPrebidVideo videoInfo;
    private final PriceFloorInfo priceFloorInfo;

    public static BidderBid of(Bid bid, BidType bidType, String bidCurrency) {
        return BidderBid.builder().bid(bid).type(bidType).bidCurrency(bidCurrency).build();
    }

    @ConstructorProperties(value={"bid", "type", "bidCurrency", "dealPriority", "videoInfo", "priceFloorInfo"})
    BidderBid(Bid bid, BidType type, String bidCurrency, Integer dealPriority, ExtBidPrebidVideo videoInfo, PriceFloorInfo priceFloorInfo) {
        this.bid = bid;
        this.type = type;
        this.bidCurrency = bidCurrency;
        this.dealPriority = dealPriority;
        this.videoInfo = videoInfo;
        this.priceFloorInfo = priceFloorInfo;
    }

    public static BidderBidBuilder builder() {
        return new BidderBidBuilder();
    }

    public BidderBidBuilder toBuilder() {
        return new BidderBidBuilder().bid(this.bid).type(this.type).bidCurrency(this.bidCurrency).dealPriority(this.dealPriority).videoInfo(this.videoInfo).priceFloorInfo(this.priceFloorInfo);
    }

    public Bid getBid() {
        return this.bid;
    }

    public BidType getType() {
        return this.type;
    }

    public String getBidCurrency() {
        return this.bidCurrency;
    }

    public Integer getDealPriority() {
        return this.dealPriority;
    }

    public ExtBidPrebidVideo getVideoInfo() {
        return this.videoInfo;
    }

    public PriceFloorInfo getPriceFloorInfo() {
        return this.priceFloorInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderBid)) {
            return false;
        }
        BidderBid other = (BidderBid)o;
        Integer this$dealPriority = this.getDealPriority();
        Integer other$dealPriority = other.getDealPriority();
        if (this$dealPriority == null ? other$dealPriority != null : !((Object)this$dealPriority).equals(other$dealPriority)) {
            return false;
        }
        Bid this$bid = this.getBid();
        Bid other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        BidType this$type = this.getType();
        BidType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$bidCurrency = this.getBidCurrency();
        String other$bidCurrency = other.getBidCurrency();
        if (this$bidCurrency == null ? other$bidCurrency != null : !this$bidCurrency.equals(other$bidCurrency)) {
            return false;
        }
        ExtBidPrebidVideo this$videoInfo = this.getVideoInfo();
        ExtBidPrebidVideo other$videoInfo = other.getVideoInfo();
        if (this$videoInfo == null ? other$videoInfo != null : !((Object)this$videoInfo).equals(other$videoInfo)) {
            return false;
        }
        PriceFloorInfo this$priceFloorInfo = this.getPriceFloorInfo();
        PriceFloorInfo other$priceFloorInfo = other.getPriceFloorInfo();
        return !(this$priceFloorInfo == null ? other$priceFloorInfo != null : !((Object)this$priceFloorInfo).equals(other$priceFloorInfo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dealPriority = this.getDealPriority();
        result = result * 59 + ($dealPriority == null ? 43 : ((Object)$dealPriority).hashCode());
        Bid $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        BidType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $bidCurrency = this.getBidCurrency();
        result = result * 59 + ($bidCurrency == null ? 43 : $bidCurrency.hashCode());
        ExtBidPrebidVideo $videoInfo = this.getVideoInfo();
        result = result * 59 + ($videoInfo == null ? 43 : ((Object)$videoInfo).hashCode());
        PriceFloorInfo $priceFloorInfo = this.getPriceFloorInfo();
        result = result * 59 + ($priceFloorInfo == null ? 43 : ((Object)$priceFloorInfo).hashCode());
        return result;
    }

    public String toString() {
        return "BidderBid(bid=" + this.getBid() + ", type=" + this.getType() + ", bidCurrency=" + this.getBidCurrency() + ", dealPriority=" + this.getDealPriority() + ", videoInfo=" + this.getVideoInfo() + ", priceFloorInfo=" + this.getPriceFloorInfo() + ")";
    }

    public static class BidderBidBuilder {
        private Bid bid;
        private BidType type;
        private String bidCurrency;
        private Integer dealPriority;
        private ExtBidPrebidVideo videoInfo;
        private PriceFloorInfo priceFloorInfo;

        BidderBidBuilder() {
        }

        public BidderBidBuilder bid(Bid bid) {
            this.bid = bid;
            return this;
        }

        public BidderBidBuilder type(BidType type) {
            this.type = type;
            return this;
        }

        public BidderBidBuilder bidCurrency(String bidCurrency) {
            this.bidCurrency = bidCurrency;
            return this;
        }

        public BidderBidBuilder dealPriority(Integer dealPriority) {
            this.dealPriority = dealPriority;
            return this;
        }

        public BidderBidBuilder videoInfo(ExtBidPrebidVideo videoInfo) {
            this.videoInfo = videoInfo;
            return this;
        }

        public BidderBidBuilder priceFloorInfo(PriceFloorInfo priceFloorInfo) {
            this.priceFloorInfo = priceFloorInfo;
            return this;
        }

        public BidderBid build() {
            return new BidderBid(this.bid, this.type, this.bidCurrency, this.dealPriority, this.videoInfo, this.priceFloorInfo);
        }

        public String toString() {
            return "BidderBid.BidderBidBuilder(bid=" + this.bid + ", type=" + this.type + ", bidCurrency=" + this.bidCurrency + ", dealPriority=" + this.dealPriority + ", videoInfo=" + this.videoInfo + ", priceFloorInfo=" + this.priceFloorInfo + ")";
        }
    }
}

