/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.mgid;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.mgid.model.ExtBidMgid;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.mgid.ExtImpMgid;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class MgidBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MgidBidder(String endpoint, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpoint));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<Imp> imps = new ArrayList<Imp>();
        String accountId = null;
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpMgid impExt = this.parseImpExt(imp);
                if (accountId == null && StringUtils.isNotBlank((CharSequence)impExt.getAccountId())) {
                    accountId = impExt.getAccountId();
                }
                Imp modifiedImp = MgidBidder.modifyImp(imp, impExt);
                imps.add(modifiedImp);
            }
            catch (PreBidException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
        }
        if (accountId == null) {
            return Result.withError(BidderError.badInput("accountId is not set"));
        }
        BidRequest outgoingRequest = bidRequest.toBuilder().tmax(bidRequest.getTmax()).imp(imps).build();
        return Result.withValue(BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl + accountId, this.mapper));
    }

    private ExtImpMgid parseImpExt(Imp imp) {
        try {
            return (ExtImpMgid)this.mapper.mapper().convertValue((Object)imp.getExt().get("bidder"), ExtImpMgid.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static Imp modifyImp(Imp imp, ExtImpMgid impExt) throws PreBidException {
        BigDecimal bidFloor;
        Imp.ImpBuilder impBuilder = imp.toBuilder();
        String cur = MgidBidder.getCur(impExt);
        if (cur != null) {
            impBuilder.bidfloorcur(cur);
        }
        if ((bidFloor = MgidBidder.getBidFloor(impExt)) != null) {
            impBuilder.bidfloor(bidFloor);
        }
        return impBuilder.tagid(MgidBidder.getTagid(imp, impExt)).build();
    }

    private static String getCur(ExtImpMgid impMgid) {
        return (String)ObjectUtils.defaultIfNull((Object)MgidBidder.currencyValueOrNull(impMgid.getCurrency()), (Object)MgidBidder.currencyValueOrNull(impMgid.getCur()));
    }

    private static String currencyValueOrNull(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && !value.equals("USD") ? value : null;
    }

    private static BigDecimal getBidFloor(ExtImpMgid impMgid) {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)MgidBidder.validBidFloorOrNull(impMgid.getBidfloor()), (Object)MgidBidder.validBidFloorOrNull(impMgid.getBidFloorSecond()));
    }

    private static BigDecimal validBidFloorOrNull(BigDecimal bidFloor) {
        return BidderUtil.isValidPrice(bidFloor) ? bidFloor : null;
    }

    private static String getTagid(Imp imp, ExtImpMgid impMgid) {
        String placementId = impMgid.getPlacementId();
        String impId = imp.getId();
        return StringUtils.isBlank((CharSequence)placementId) ? impId : "%s/%s".formatted(placementId, impId);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, this.getBidType((Bid)bid), bidResponse.getCur())).toList();
    }

    private BidType getBidType(Bid bid) {
        ExtBidMgid bidExt = this.getBidExt(bid);
        if (bidExt == null) {
            return BidType.banner;
        }
        BidType crtype = bidExt.getCrtype();
        return crtype == null ? BidType.banner : crtype;
    }

    private ExtBidMgid getBidExt(Bid bid) {
        try {
            return (ExtBidMgid)this.mapper.mapper().convertValue((Object)bid.getExt(), ExtBidMgid.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

