/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.madvertise;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.madvertise.ExtImpMadvertise;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class MadvertiseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMadvertise>> MADVERTISE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpMadvertise>>(){};
    private static final int ZONE_ID_MIN_LENGTH = 7;
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final String ZONE_ID_MACRO = "{{ZoneID}}";
    private static final Set<Integer> VIDEO_BID_ATTRS = Set.of(Integer.valueOf(16), Integer.valueOf(6), Integer.valueOf(7));
    private final JacksonMapper mapper;
    private final String endpointUrl;

    public MadvertiseBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        String zoneId = null;
        for (Imp imp : request.getImp()) {
            String impZoneId;
            try {
                impZoneId = this.parseImpExt(imp).getZoneId();
            }
            catch (PreBidException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
            if (zoneId == null) {
                zoneId = impZoneId;
                continue;
            }
            if (zoneId.equals(impZoneId)) continue;
            return Result.withError(BidderError.badInput("There must be only one zone ID"));
        }
        return Result.withValue(this.createRequest(request, zoneId));
    }

    private ExtImpMadvertise parseImpExt(Imp imp) {
        ExtImpMadvertise extImpMadvertise;
        String impId = imp.getId();
        try {
            extImpMadvertise = (ExtImpMadvertise)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MADVERTISE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + impId);
        }
        if (StringUtils.length((CharSequence)extImpMadvertise.getZoneId()) < 7) {
            throw new PreBidException("The minLength of zone ID is 7; ImpID=" + impId);
        }
        return extImpMadvertise;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, String zoneID) {
        String url = this.endpointUrl.replace(ZONE_ID_MACRO, HttpUtil.encodeUrl(zoneID));
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(MadvertiseBidder.resolveHeaders(request.getDevice())).payload(request).body(this.mapper.encodeToBytes(request)).build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        headers.add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)X_OPENRTB_VERSION);
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
        }
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(MadvertiseBidder.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, MadvertiseBidder.getBidMediaType(bid.getAttr()), bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(List<Integer> bidAttrs) {
        return CollectionUtils.emptyIfNull(bidAttrs).stream().anyMatch(VIDEO_BID_ATTRS::contains) ? BidType.video : BidType.banner;
    }
}

