/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.limelightdigital;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.limelightdigital.ExtImpLimeLightDigital;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class LimeLightDigitalBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpLimeLightDigital>> LIME_LIGHT_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpLimeLightDigital>>(){};
    private static final String BIDDER_CURRENCY = "USD";
    private static final String URL_HOST_MACRO = "{{Host}}";
    private static final String URL_PUBLISHER_ID_MACRO = "{{PublisherID}}";
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public LimeLightDigitalBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpLimeLightDigital extImpAdview = this.parseExtImp(imp);
                String endpointUri = this.resolveEndpoint(extImpAdview);
                Imp modifiedImp = this.modifyImp(imp, request);
                BidRequest modifiedBidRequest = LimeLightDigitalBidder.modifyRequest(request, modifiedImp);
                requests.add(this.createHttpRequest(modifiedBidRequest, endpointUri));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpLimeLightDigital parseExtImp(Imp imp) {
        try {
            return (ExtImpLimeLightDigital)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), LIME_LIGHT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder is not provided");
        }
    }

    private String resolveEndpoint(ExtImpLimeLightDigital extImp) {
        String publisherId = String.valueOf(extImp.getPublisherId());
        return this.endpointUrl.replace(URL_HOST_MACRO, HttpUtil.encodeUrl(extImp.getHost())).replace(URL_PUBLISHER_ID_MACRO, HttpUtil.encodeUrl(publisherId));
    }

    private Imp modifyImp(Imp imp, BidRequest request) {
        Price bidFloorPrice = this.resolveBidFloor(imp, request);
        return imp.toBuilder().bidfloor(bidFloorPrice.getValue()).bidfloorcur(bidFloorPrice.getCurrency()).ext(null).build();
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of(imp.getBidfloorcur(), imp.getBidfloor());
        return BidderUtil.isValidPrice(initialBidFloorPrice) ? this.convertBidFloor(initialBidFloorPrice, imp.getId(), bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, String impId, BidRequest bidRequest) {
        String bidFloorCur = bidFloorPrice.getCurrency();
        try {
            BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorCur, BIDDER_CURRENCY);
            return Price.of(BIDDER_CURRENCY, convertedPrice);
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s`".formatted(bidFloorCur, BIDDER_CURRENCY, impId));
        }
    }

    private static BidRequest modifyRequest(BidRequest bidRequest, Imp imp) {
        return bidRequest.toBuilder().id(bidRequest.getId() + "-" + imp.getId()).imp(Collections.singletonList(imp)).ext(null).build();
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest modifiedBidRequest, String endpointUri) {
        return BidderUtil.defaultRequest(modifiedBidRequest, endpointUri, this.mapper);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> errors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(LimeLightDigitalBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return LimeLightDigitalBidder.bidsFromResponse(bidRequest, bidResponse, errors);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> LimeLightDigitalBidder.resolveBidderBid(bid, bidResponse.getCur(), bidRequest.getImp(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid resolveBidderBid(Bid bid, String currency, List<Imp> imps, List<BidderError> errors) {
        BidType bidType;
        try {
            bidType = LimeLightDigitalBidder.getBidType(bid.getImpid(), imps);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        return BidderBid.of(bid, bidType, currency);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getAudio() != null) {
                return BidType.audio;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            throw new PreBidException("Unknown media type of imp: '%s'".formatted(impId));
        }
        throw new PreBidException("Bid contains unknown imp id: '%s'".formatted(impId));
    }
}

