/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads.model.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.prebid.server.bidder.huaweiads.model.request.CellInfo;

public final class Network {
    private final Integer type;
    private final Integer carrier;
    @JsonProperty(value="cellInfo")
    private final List<CellInfo> cellInfo;

    @ConstructorProperties(value={"type", "carrier", "cellInfo"})
    Network(Integer type, Integer carrier, List<CellInfo> cellInfo) {
        this.type = type;
        this.carrier = carrier;
        this.cellInfo = cellInfo;
    }

    public static NetworkBuilder builder() {
        return new NetworkBuilder();
    }

    public NetworkBuilder toBuilder() {
        return new NetworkBuilder().type(this.type).carrier(this.carrier).cellInfo(this.cellInfo);
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getCarrier() {
        return this.carrier;
    }

    public List<CellInfo> getCellInfo() {
        return this.cellInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Network)) {
            return false;
        }
        Network other = (Network)o;
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$carrier = this.getCarrier();
        Integer other$carrier = other.getCarrier();
        if (this$carrier == null ? other$carrier != null : !((Object)this$carrier).equals(other$carrier)) {
            return false;
        }
        List<CellInfo> this$cellInfo = this.getCellInfo();
        List<CellInfo> other$cellInfo = other.getCellInfo();
        return !(this$cellInfo == null ? other$cellInfo != null : !((Object)this$cellInfo).equals(other$cellInfo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $carrier = this.getCarrier();
        result = result * 59 + ($carrier == null ? 43 : ((Object)$carrier).hashCode());
        List<CellInfo> $cellInfo = this.getCellInfo();
        result = result * 59 + ($cellInfo == null ? 43 : ((Object)$cellInfo).hashCode());
        return result;
    }

    public String toString() {
        return "Network(type=" + this.getType() + ", carrier=" + this.getCarrier() + ", cellInfo=" + this.getCellInfo() + ")";
    }

    public static class NetworkBuilder {
        private Integer type;
        private Integer carrier;
        private List<CellInfo> cellInfo;

        NetworkBuilder() {
        }

        public NetworkBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public NetworkBuilder carrier(Integer carrier) {
            this.carrier = carrier;
            return this;
        }

        @JsonProperty(value="cellInfo")
        public NetworkBuilder cellInfo(List<CellInfo> cellInfo) {
            this.cellInfo = cellInfo;
            return this;
        }

        public Network build() {
            return new Network(this.type, this.carrier, this.cellInfo);
        }

        public String toString() {
            return "Network.NetworkBuilder(type=" + this.type + ", carrier=" + this.carrier + ", cellInfo=" + this.cellInfo + ")";
        }
    }
}

