/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads;

import com.iab.openrtb.request.Device;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.huaweiads.model.request.CellInfo;
import org.prebid.server.bidder.huaweiads.model.request.Network;

public class HuaweiNetworkBuilder {
    private static final int DEFAULT_UNKNOWN_NETWORK_TYPE = 0;

    public Network build(Device device) {
        if (device == null) {
            return null;
        }
        ArrayList<CellInfo> cellInfos = new ArrayList<CellInfo>();
        Integer carrier = null;
        if (StringUtils.isNotBlank((CharSequence)device.getMccmnc())) {
            String[] mccmnc = device.getMccmnc().split("-");
            carrier = 0;
            if (mccmnc.length >= 2) {
                String mcc = mccmnc[0];
                String mnc = mccmnc[1];
                cellInfos.add(CellInfo.of(mcc, mnc));
                carrier = switch (mcc + mnc) {
                    case "46001", "46006" -> 1;
                    case "46000", "46002", "46007" -> 2;
                    case "46003", "46005", "46011" -> 3;
                    default -> 99;
                };
            }
        }
        Integer type = device.getConnectiontype() == null ? 0 : device.getConnectiontype();
        return Network.builder().type(type).cellInfo(cellInfos).carrier(carrier).build();
    }
}

