/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.grid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.grid.model.request.KeywordSegment;
import org.prebid.server.bidder.grid.model.request.Keywords;
import org.prebid.server.bidder.grid.model.request.KeywordsPublisherItem;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.ObjectUtil;

public class GridKeywordsProcessor {
    private static final TypeReference<Map<String, JsonNode>> MAP_TYPE_REF = new TypeReference<Map<String, JsonNode>>(){};
    private static final String KEYWORDS_PROPERTY = "keywords";
    private static final String USER_PROPERTY = "user";
    private static final String SITE_PROPERTY = "site";
    private final JacksonMapper mapper;

    public GridKeywordsProcessor(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Map<String, JsonNode> modifyWithKeywords(Map<String, JsonNode> extRequestProperties, Keywords keywords) {
        JsonNode keywordsJsonNode = extRequestProperties.get(KEYWORDS_PROPERTY);
        ObjectNode keywordsNode = GridKeywordsProcessor.isObjectNode(keywordsJsonNode) ? (ObjectNode)keywordsJsonNode : this.mapper.mapper().createObjectNode();
        GridKeywordsProcessor.setIfNotNullOrRemove(keywordsNode, USER_PROPERTY, (JsonNode)GridKeywordsProcessor.stripToNull(keywords.getUser()));
        GridKeywordsProcessor.setIfNotNullOrRemove(keywordsNode, SITE_PROPERTY, (JsonNode)GridKeywordsProcessor.stripToNull(keywords.getSite()));
        HashMap<String, JsonNode> modifiedExtRequestProperties = new HashMap<String, JsonNode>(extRequestProperties);
        if (!keywordsNode.isEmpty()) {
            modifiedExtRequestProperties.put(KEYWORDS_PROPERTY, (JsonNode)keywordsNode);
        } else {
            modifiedExtRequestProperties.remove(KEYWORDS_PROPERTY);
        }
        return modifiedExtRequestProperties;
    }

    private static void setIfNotNullOrRemove(ObjectNode node, String key, JsonNode value) {
        if (value != null) {
            node.set(key, value);
        } else {
            node.remove(key);
        }
    }

    public Keywords resolveKeywordsFromOpenRtb(String userKeywords, String siteKeywords) {
        return Keywords.of(this.resolveKeywordsSectionFromOpenRtb(userKeywords), this.resolveKeywordsSectionFromOpenRtb(siteKeywords));
    }

    public ObjectNode resolveKeywordsSectionFromOpenRtb(String keywords) {
        List<KeywordSegment> segments = Arrays.stream(keywords.split(",")).filter(StringUtils::isNotEmpty).map(keyword -> KeywordSegment.of(KEYWORDS_PROPERTY, keyword)).toList();
        ObjectNode publisherNode = this.mapper.mapper().createObjectNode();
        if (!segments.isEmpty()) {
            List<KeywordsPublisherItem> publisherItems = Collections.singletonList(KeywordsPublisherItem.of(KEYWORDS_PROPERTY, segments));
            return (ObjectNode)publisherNode.set("ortb2", this.mapper.mapper().valueToTree(publisherItems));
        }
        return publisherNode;
    }

    public Keywords resolveKeywords(Keywords keywords) {
        return keywords == null ? Keywords.empty() : Keywords.of(this.resolveKeywordsSection(keywords.getUser()), this.resolveKeywordsSection(keywords.getSite()));
    }

    public ObjectNode resolveKeywordsSection(ObjectNode sectionNode) {
        if (sectionNode == null) {
            return null;
        }
        ObjectNode resolvedSectionNode = this.mapper.mapper().createObjectNode();
        Map<String, JsonNode> sectionMap = this.jsonNodeToMap((JsonNode)sectionNode);
        for (Map.Entry<String, JsonNode> entry : sectionMap.entrySet()) {
            List<KeywordsPublisherItem> publisherKeywords;
            JsonNode publisherJsonNode = entry.getValue();
            if (!GridKeywordsProcessor.isArrayNode(publisherJsonNode) || (publisherKeywords = this.resolvePublisherKeywords(publisherJsonNode)).isEmpty()) continue;
            resolvedSectionNode.set(entry.getKey(), this.mapper.mapper().valueToTree(publisherKeywords));
        }
        return resolvedSectionNode;
    }

    public List<KeywordsPublisherItem> resolvePublisherKeywords(JsonNode publisherNode) {
        ArrayList<KeywordsPublisherItem> publishersKeywords = new ArrayList<KeywordsPublisherItem>();
        Iterator publisherNodeElements = publisherNode.elements();
        while (publisherNodeElements.hasNext()) {
            JsonNode publisherValueNode = (JsonNode)publisherNodeElements.next();
            JsonNode publisherNameNode = publisherValueNode.get("name");
            JsonNode segmentsNode = publisherValueNode.get("segments");
            if (!GridKeywordsProcessor.isTextualNode(publisherNameNode)) continue;
            ArrayList<KeywordSegment> segments = new ArrayList<KeywordSegment>(GridKeywordsProcessor.resolvePublisherSegments(segmentsNode));
            segments.addAll(this.resolveAlternativePublisherSegments(publisherValueNode));
            if (segments.isEmpty()) continue;
            publishersKeywords.add(KeywordsPublisherItem.of(publisherNameNode.asText(), segments));
        }
        return publishersKeywords;
    }

    public static List<KeywordSegment> resolvePublisherSegments(JsonNode segmentsNode) {
        ArrayList<KeywordSegment> parsedSegments = new ArrayList<KeywordSegment>();
        if (!GridKeywordsProcessor.isArrayNode(segmentsNode)) {
            return parsedSegments;
        }
        Iterator segments = segmentsNode.elements();
        while (segments.hasNext()) {
            KeywordSegment keywordSegment = GridKeywordsProcessor.resolvePublisherSegment((JsonNode)segments.next());
            if (keywordSegment == null) continue;
            parsedSegments.add(keywordSegment);
        }
        return parsedSegments;
    }

    public static KeywordSegment resolvePublisherSegment(JsonNode segmentNode) {
        JsonNode nameNode = segmentNode.get("name");
        String name = GridKeywordsProcessor.isTextualNode(nameNode) ? nameNode.asText() : null;
        JsonNode valueNode = segmentNode.get("value");
        String value = GridKeywordsProcessor.isTextualNode(valueNode) ? valueNode.asText() : null;
        return StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value) ? KeywordSegment.of(name, value) : null;
    }

    public List<KeywordSegment> resolveAlternativePublisherSegments(JsonNode publisherValueNode) {
        return this.jsonNodeToMap(publisherValueNode).entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(publisherEntry -> GridKeywordsProcessor.isArrayNode((JsonNode)publisherEntry.getValue())).map(GridKeywordsProcessor::mapPublisherEntryToKeywordSegmentList).flatMap(Collection::stream).toList();
    }

    private static List<KeywordSegment> mapPublisherEntryToKeywordSegmentList(Map.Entry<String, JsonNode> publisherEntry) {
        ArrayList<KeywordSegment> keywordSegments = new ArrayList<KeywordSegment>();
        Iterator publisherEntryElements = publisherEntry.getValue().elements();
        while (publisherEntryElements.hasNext()) {
            JsonNode currentNode = (JsonNode)publisherEntryElements.next();
            if (!currentNode.isTextual()) continue;
            keywordSegments.add(KeywordSegment.of(publisherEntry.getKey(), currentNode.asText()));
        }
        return keywordSegments;
    }

    public Keywords merge(Keywords ... keywords) {
        return Keywords.of(this.mergeSections(this.extractSections(Keywords::getUser, keywords)), this.mergeSections(this.extractSections(Keywords::getSite, keywords)));
    }

    public Stream<ObjectNode> extractSections(Function<Keywords, ObjectNode> extractor, Keywords ... keywords) {
        return Arrays.stream(keywords).map(keyword -> GridKeywordsProcessor.stripToNull((ObjectNode)ObjectUtil.getIfNotNull(keyword, extractor))).filter(Objects::nonNull);
    }

    private ObjectNode mergeSections(Stream<ObjectNode> sections) {
        return sections.reduce(this.mapper.mapper().createObjectNode(), (left, right) -> (ObjectNode)GridKeywordsProcessor.mergeSections((JsonNode)left, (JsonNode)right));
    }

    public static JsonNode mergeSections(JsonNode firstSection, JsonNode secondSection) {
        Iterator updateFieldNames = secondSection.fieldNames();
        while (updateFieldNames.hasNext()) {
            String updateFieldName = (String)updateFieldNames.next();
            JsonNode valueToBeUpdated = firstSection.get(updateFieldName);
            JsonNode updateValue = secondSection.get(updateFieldName);
            if (GridKeywordsProcessor.isArrayNode(valueToBeUpdated) && GridKeywordsProcessor.isArrayNode(updateValue)) {
                ArrayNode arrayToBeUpdated = (ArrayNode)valueToBeUpdated;
                for (JsonNode updateChildNode : updateValue) {
                    arrayToBeUpdated.add(updateChildNode);
                }
                continue;
            }
            if (GridKeywordsProcessor.isObjectNode(valueToBeUpdated)) {
                GridKeywordsProcessor.mergeSections(valueToBeUpdated, updateValue);
                continue;
            }
            if (!GridKeywordsProcessor.isObjectNode(firstSection)) continue;
            ((ObjectNode)firstSection).replace(updateFieldName, updateValue);
        }
        return firstSection;
    }

    private Map<String, JsonNode> jsonNodeToMap(JsonNode jsonNode) {
        try {
            return GridKeywordsProcessor.isObjectNode(jsonNode) ? (Map)this.mapper.mapper().convertValue((Object)jsonNode, MAP_TYPE_REF) : Collections.emptyMap();
        }
        catch (IllegalArgumentException ignored) {
            return Collections.emptyMap();
        }
    }

    private static ObjectNode stripToNull(ObjectNode objectNode) {
        return objectNode != null && !objectNode.isEmpty() ? objectNode : null;
    }

    private static boolean isArrayNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isArray();
    }

    private static boolean isObjectNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isObject();
    }

    private static boolean isTextualNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isTextual();
    }
}

