/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.frvradn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.frvradn.model.ExtImpFrvrAdn;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class FrvrAdnBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpFrvrAdn>> FRVRADN_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpFrvrAdn>>(){};
    private static final String DEFAULT_BID_CURRENCY = "USD";
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final JacksonMapper mapper;

    public FrvrAdnBidder(String endpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(endpointUrl);
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpFrvrAdn impExt = this.parseImpExt(imp);
                Imp modifiedImp = this.modifyImp(imp, impExt, bidRequest);
                requests.add(this.makeHttpRequest(bidRequest, modifiedImp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpFrvrAdn parseImpExt(Imp imp) {
        try {
            return (ExtImpFrvrAdn)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), FRVRADN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp modifyImp(Imp imp, ExtImpFrvrAdn extImpFrvrAdn, BidRequest bidRequest) {
        Price resolvedBidFloor = this.resolveBidFloor(imp, bidRequest);
        return imp.toBuilder().bidfloor(resolvedBidFloor.getValue()).bidfloorcur(resolvedBidFloor.getCurrency()).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)extImpFrvrAdn)).build();
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of(imp.getBidfloorcur(), imp.getBidfloor());
        return BidderUtil.shouldConvertBidFloor(initialBidFloorPrice, DEFAULT_BID_CURRENCY) ? this.convertBidFloor(initialBidFloorPrice, bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, BidRequest bidRequest) {
        BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorPrice.getCurrency(), DEFAULT_BID_CURRENCY);
        return Price.of(DEFAULT_BID_CURRENCY, convertedPrice);
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, Imp imp) {
        BidRequest modifiedBidRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest(modifiedBidRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList<BidderError> errors = new ArrayList<BidderError>();
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(FrvrAdnBidder.extractBids(bidResponse, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return FrvrAdnBidder.bidsFromResponse(bidResponse, errors);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> FrvrAdnBidder.makeBidderBid(bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, String cur, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, FrvrAdnBidder.getBidType(bid), cur);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(Bid bid) {
        return Optional.ofNullable(bid.getExt()).map(bidExt -> bidExt.at("/prebid/type")).filter(JsonNode::isTextual).map(JsonNode::asText).map(BidType::fromString).orElseThrow(() -> new PreBidException("unable to deserialize imp %s bid.ext".formatted(bid.getImpid())));
    }
}

