/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.cpmstar;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.cpmstar.ExtImpCpmStar;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class CpmStarBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpCpmStar>> CPM_STAR_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpCpmStar>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public CpmStarBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        try {
            BidRequest bidRequest = this.processRequest(request);
            return Result.of(Collections.singletonList(BidderUtil.defaultRequest(bidRequest, this.endpointUrl, this.mapper)), Collections.emptyList());
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
    }

    private BidRequest processRequest(BidRequest bidRequest) {
        ArrayList<Imp> validImpList = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            ExtImpCpmStar extImpCpmStar = this.parseImp(imp);
            validImpList.add(this.createImp(extImpCpmStar, imp));
        }
        return bidRequest.toBuilder().imp(validImpList).build();
    }

    private ExtImpCpmStar parseImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("Only Banner and Video bid-types are supported at this time");
        }
        try {
            return (ExtImpCpmStar)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), CPM_STAR_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp createImp(ExtImpCpmStar extImpCpmStar, Imp imp) {
        if (extImpCpmStar == null) {
            throw new PreBidException("imp id=%s: bidder.ext is null".formatted(imp.getId()));
        }
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)extImpCpmStar)).build();
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return this.extractBids(httpCall.getRequest().getPayload(), bidResponse);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private Result<List<BidderBid>> extractBids(BidRequest request, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.of(Collections.emptyList(), Collections.emptyList());
        }
        List<Bid> responseBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> result = CpmStarBidder.bidsFromResponse(request.getImp(), responseBids, bidResponse.getCur(), errors);
        return Result.of(result, errors);
    }

    private static List<BidderBid> bidsFromResponse(List<Imp> imps, List<Bid> responseBids, String currency, List<BidderError> errors) {
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        for (Bid bid : responseBids) {
            try {
                bidderBids.add(BidderBid.of(bid, CpmStarBidder.bidType(bid.getImpid(), imps), currency));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput("bid id=%s %s".formatted(bid.getId(), e.getMessage())));
            }
        }
        return bidderBids;
    }

    private static BidType bidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() == null) continue;
            return BidType.video;
        }
        throw new PreBidException("could not find valid impid=" + impId);
    }
}

