/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bmtm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.bmtm.ExtImpBmtm;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class BmtmBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<ExtImpPrebid, ExtImpBmtm>> BMTM_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<ExtImpPrebid, ExtImpBmtm>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BmtmBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                BmtmBidder.validateImp(imp);
                ExtImpBmtm impExt = this.parseImpExt(imp);
                BidRequest outgoingRequest = BmtmBidder.createRequest(request, BmtmBidder.modifyImp(imp, impExt));
                httpRequests.add(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes(outgoingRequest)).headers(BmtmBidder.createHeaders(request)).payload(outgoingRequest).build());
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("For Imp ID %s Banner or Video is undefined".formatted(imp.getId()));
        }
    }

    private static Imp modifyImp(Imp imp, ExtImpBmtm impExt) {
        return imp.toBuilder().tagid(impExt.getPlacementId()).ext(null).build();
    }

    private static BidRequest createRequest(BidRequest request, Imp modifiedImp) {
        return request.toBuilder().imp(Collections.singletonList(modifiedImp)).build();
    }

    private ExtImpBmtm parseImpExt(Imp imp) {
        try {
            return (ExtImpBmtm)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BMTM_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + imp.getId());
        }
    }

    private static MultiMap createHeaders(BidRequest request) {
        Site site;
        MultiMap headers = HttpUtil.headers();
        Device device = request.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, StringUtils.defaultIfEmpty((CharSequence)device.getIp(), (CharSequence)device.getIpv6()));
        }
        String page = (site = request.getSite()) != null ? site.getPage() : null;
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, page);
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(BmtmBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return BmtmBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, BmtmBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!impId.equals(imp.getId())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() == null) continue;
            return BidType.video;
        }
        return BidType.banner;
    }
}

