/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bidscube;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class BidscubeBidder
implements Bidder<BidRequest> {
    private static final Set<String> POSSIBLE_BID_TYPES = Set.of("banner", "video", "native");
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BidscubeBidder(JacksonMapper mapper, String endpointUrl) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                requests.add(this.createRequest(request, imp, BidscubeBidder.getBidderNode(imp)));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private static ObjectNode getBidderNode(Imp imp) {
        JsonNode bidderExtNode;
        ObjectNode impExtNode = imp.getExt();
        JsonNode jsonNode = bidderExtNode = BidscubeBidder.isNotEmptyOrMissedNode((JsonNode)impExtNode) ? impExtNode.get("bidder") : null;
        if (!BidscubeBidder.isNotEmptyOrMissedNode(bidderExtNode)) {
            throw new PreBidException("Missing required bidder parameters");
        }
        return (ObjectNode)bidderExtNode.deepCopy();
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, Imp imp, ObjectNode bidderNode) {
        Imp internalImp = imp.toBuilder().ext(bidderNode).build();
        BidRequest internalRequest = request.toBuilder().imp(Collections.singletonList(internalImp)).build();
        return BidderUtil.defaultRequest(internalRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.constructBidderBid((Bid)bid, bidResponse, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid constructBidderBid(Bid bid, BidResponse bidResponse, List<BidderError> errors) {
        JsonNode typeNode;
        ObjectNode extNode = bid.getExt();
        JsonNode jsonNode = typeNode = BidscubeBidder.isNotEmptyOrMissedNode((JsonNode)extNode) ? extNode.at("/prebid/type") : null;
        if (typeNode == null || !typeNode.isTextual()) {
            errors.add(BidderError.badInput("Unable to read bid.ext.prebid.type"));
            return null;
        }
        return BidderBid.of(bid, this.resolveBidType(typeNode), bidResponse.getCur());
    }

    private static boolean isNotEmptyOrMissedNode(JsonNode node) {
        return node != null && !node.isEmpty();
    }

    private BidType resolveBidType(JsonNode bidType) {
        return !POSSIBLE_BID_TYPES.contains(bidType.asText()) ? BidType.banner : (BidType)((Object)this.mapper.mapper().convertValue((Object)bidType, BidType.class));
    }
}

