/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.bidmachine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.bidmachine.ExtImpBidmachine;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class BidmachineBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<ExtImpPrebid, ExtImpBidmachine>> BIDMACHINE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<ExtImpPrebid, ExtImpBidmachine>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public BidmachineBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                BidmachineBidder.validateImp(imp);
                ExtPrebid<ExtImpPrebid, ExtImpBidmachine> mappedExt = this.parseImpExt(imp);
                BidRequest outgoingRequest = this.createRequest(imp, mappedExt.getPrebid(), request);
                httpRequests.add(HttpRequest.builder().method(HttpMethod.POST).uri(this.buildEndpointUrl(mappedExt.getBidder())).body(this.mapper.encodeToBytes(outgoingRequest)).headers(BidmachineBidder.resolveHeaders()).payload(outgoingRequest).build());
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private static void validateImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner == null) {
            return;
        }
        if (banner.getW() == null && banner.getH() == null) {
            List<Format> format = banner.getFormat();
            if (format == null) {
                throw new PreBidException("Impression with id: %s has following error: Banner width and height is not provided and banner format is missing. At least one is required".formatted(imp.getId()));
            }
            if (format.isEmpty()) {
                throw new PreBidException("Impression with id: %s has following error: Banner width and height is not provided and banner format array is empty. At least one is required".formatted(imp.getId()));
            }
        }
    }

    private BidRequest createRequest(Imp imp, ExtImpPrebid extPrebid, BidRequest request) {
        return request.toBuilder().imp(Collections.singletonList(this.modifyImp(imp, extPrebid))).build();
    }

    private Imp modifyImp(Imp imp, ExtImpPrebid extPrebid) {
        if (extPrebid != null && Objects.equals(extPrebid.getIsRewardedInventory(), 1)) {
            List<Integer> resolvedVideoBattr;
            Banner banner = imp.getBanner();
            List<Integer> resolvedBannerBattr = banner == null ? null : BidmachineBidder.resolveBattrList(banner.getBattr());
            Video video = imp.getVideo();
            List<Integer> list = resolvedVideoBattr = video == null ? null : BidmachineBidder.resolveBattrList(video.getBattr());
            if (resolvedBannerBattr != null || resolvedVideoBattr != null) {
                Imp.ImpBuilder impBuilder = imp.toBuilder();
                if (resolvedBannerBattr != null) {
                    impBuilder.banner(banner.toBuilder().battr(resolvedBannerBattr).build());
                }
                if (resolvedVideoBattr != null) {
                    impBuilder.video(video.toBuilder().battr(resolvedVideoBattr).build());
                }
                return impBuilder.build();
            }
        }
        return imp;
    }

    private static List<Integer> resolveBattrList(List<Integer> battr) {
        if (BidmachineBidder.isMissedRewardedBattr(battr)) {
            ArrayList<Integer> updatedBattr = battr == null ? new ArrayList<Integer>() : new ArrayList<Integer>(battr);
            updatedBattr.add(16);
            return updatedBattr;
        }
        return null;
    }

    private static boolean isMissedRewardedBattr(List<Integer> battr) {
        return battr == null || !battr.contains(16);
    }

    private String buildEndpointUrl(ExtImpBidmachine extImpBidmachine) {
        return this.endpointUrl.replace("{{HOST}}", extImpBidmachine.getHost()).replace("{{PATH}}", extImpBidmachine.getPath()).replace("{{SELLER_ID}}", extImpBidmachine.getSellerId());
    }

    private ExtPrebid<ExtImpPrebid, ExtImpBidmachine> parseImpExt(Imp imp) {
        try {
            return (ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BIDMACHINE_EXT_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + imp.getId());
        }
    }

    private static MultiMap resolveHeaders() {
        MultiMap headers = HttpUtil.headers();
        headers.add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return BidmachineBidder.bidsFromResponse(bidRequest, bidResponse, errors);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidmachineBidder.createBidderBid(bid, bidRequest.getImp(), bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid createBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        BidType bidType = BidmachineBidder.getBidType(bid.getImpid(), imps);
        if (bidType == null) {
            errors.add(BidderError.badServerResponse("ignoring bid id=%s, request doesn't contain any valid impression with id=%s".formatted(bid.getId(), bid.getImpid())));
            return null;
        }
        return BidderBid.of(bid, bidType, currency);
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!impId.equals(imp.getId())) continue;
            if (imp.getBanner() == null && imp.getVideo() != null) {
                return BidType.video;
            }
            return BidType.banner;
        }
        return null;
    }
}

