/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.appnexus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.Endpoint;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.appnexus.model.ImpWithExtProperties;
import org.prebid.server.bidder.appnexus.proto.AppnexusBidExt;
import org.prebid.server.bidder.appnexus.proto.AppnexusBidExtAppnexus;
import org.prebid.server.bidder.appnexus.proto.AppnexusBidExtCreative;
import org.prebid.server.bidder.appnexus.proto.AppnexusBidExtVideo;
import org.prebid.server.bidder.appnexus.proto.AppnexusImpExt;
import org.prebid.server.bidder.appnexus.proto.AppnexusImpExtAppnexus;
import org.prebid.server.bidder.appnexus.proto.AppnexusKeyVal;
import org.prebid.server.bidder.appnexus.proto.AppnexusReqExtAppnexus;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtAppPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidServer;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.appnexus.ExtImpAppnexus;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class AppnexusBidder
implements Bidder<BidRequest> {
    private static final int AD_POSITION_ABOVE_THE_FOLD = 1;
    private static final int AD_POSITION_BELOW_THE_FOLD = 3;
    private static final int MAX_IMP_PER_REQUEST = 10;
    private static final int DEFAULT_PLATFORM_ID = 5;
    private static final String POD_SEPARATOR = "_";
    private static final TypeReference<ExtPrebid<?, ExtImpAppnexus>> APPNEXUS_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAppnexus>>(){};
    private final String endpointUrl;
    private final Integer headerBiddingSource;
    private final Map<Integer, String> iabCategories;
    private final JacksonMapper mapper;
    private final Random rand = new Random();

    public AppnexusBidder(String endpointUrl, Integer platformId, Map<Integer, String> iabCategories, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.headerBiddingSource = (Integer)ObjectUtils.defaultIfNull((Object)platformId, (Object)5);
        this.iabCategories = (Map)ObjectUtils.defaultIfNull(iabCategories, Collections.emptyMap());
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String defaultDisplayManagerVer = this.makeDefaultDisplayManagerVer(bidRequest);
        ArrayList<Imp> processedImps = new ArrayList<Imp>();
        HashSet<String> uniqueIds = new HashSet<String>();
        Boolean generateAdPodId = null;
        for (Imp imp : bidRequest.getImp()) {
            try {
                ImpWithExtProperties impWithExtProperties = this.processImp(imp, defaultDisplayManagerVer);
                Boolean impGenerateAdPodId = impWithExtProperties.getGenerateAdPodId();
                generateAdPodId = (Boolean)ObjectUtils.defaultIfNull(generateAdPodId, (Object)impGenerateAdPodId);
                if (!Objects.equals(generateAdPodId, impGenerateAdPodId)) {
                    errors.add(BidderError.badInput("Generate ad pod option should be same for all pods in request"));
                    return Result.withErrors(errors);
                }
                processedImps.add(impWithExtProperties.getImp());
                String memberId = impWithExtProperties.getMemberId();
                if (memberId == null) continue;
                uniqueIds.add(memberId);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (processedImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        String url = this.constructUrl(uniqueIds, errors);
        return Result.of(this.constructRequests(bidRequest, processedImps, url, generateAdPodId), errors);
    }

    private String makeDefaultDisplayManagerVer(BidRequest bidRequest) {
        ExtApp extApp = ObjectUtil.getIfNotNull(bidRequest.getApp(), App::getExt);
        ExtAppPrebid prebid = ObjectUtil.getIfNotNull(extApp, ExtApp::getPrebid);
        String source = ObjectUtil.getIfNotNull(prebid, ExtAppPrebid::getSource);
        String version = ObjectUtil.getIfNotNull(prebid, ExtAppPrebid::getVersion);
        return ObjectUtils.allNotNull((Object[])new Object[]{source, version}) ? "%s-%s".formatted(source, version) : null;
    }

    private ImpWithExtProperties processImp(Imp imp, String defaultDisplayManagerVer) {
        ExtImpAppnexus appnexusExt = this.validateAndResolveImpExt(imp);
        Imp.ImpBuilder impBuilder = imp.toBuilder().banner(AppnexusBidder.makeBanner(imp.getBanner(), appnexusExt)).ext(this.makeImpExt(appnexusExt));
        String invCode = appnexusExt.getInvCode();
        if (StringUtils.isNotBlank((CharSequence)invCode)) {
            impBuilder.tagid(invCode);
        }
        BigDecimal reserve = appnexusExt.getReserve();
        if (!BidderUtil.isValidPrice(imp.getBidfloor()) && BidderUtil.isValidPrice(reserve)) {
            impBuilder.bidfloor(reserve);
        }
        if (StringUtils.isBlank((CharSequence)imp.getDisplaymanagerver()) && StringUtils.isNotBlank((CharSequence)defaultDisplayManagerVer)) {
            impBuilder.displaymanagerver(defaultDisplayManagerVer);
        }
        return ImpWithExtProperties.of(impBuilder.build(), appnexusExt.getMember(), appnexusExt.getGenerateAdPodId());
    }

    private ExtImpAppnexus validateAndResolveImpExt(Imp imp) {
        try {
            ExtImpAppnexus ext = (ExtImpAppnexus)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), APPNEXUS_EXT_TYPE_REFERENCE)).getBidder();
            ExtImpAppnexus resolvedExt = AppnexusBidder.resolveLegacyParameters(ext);
            AppnexusBidder.validateExtImpAppnexus(resolvedExt);
            return resolvedExt;
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private static ExtImpAppnexus resolveLegacyParameters(ExtImpAppnexus extImpAppnexus) {
        if (!AppnexusBidder.shouldReplaceWithLegacyParameters(extImpAppnexus)) {
            return extImpAppnexus;
        }
        Integer resolvedPlacementId = (Integer)ObjectUtils.defaultIfNull((Object)extImpAppnexus.getPlacementId(), (Object)extImpAppnexus.getDeprecatedPlacementId());
        String resolvedInvCode = (String)ObjectUtils.defaultIfNull((Object)extImpAppnexus.getInvCode(), (Object)extImpAppnexus.getLegacyInvCode());
        String resolvedTrafficSourceCode = (String)ObjectUtils.defaultIfNull((Object)extImpAppnexus.getTrafficSourceCode(), (Object)extImpAppnexus.getLegacyTrafficSourceCode());
        Boolean resolvedUsePaymentRule = (Boolean)ObjectUtils.defaultIfNull((Object)extImpAppnexus.getUsePmtRule(), (Object)extImpAppnexus.getDeprecatedUsePaymentRule());
        return extImpAppnexus.toBuilder().placementId(resolvedPlacementId).invCode(resolvedInvCode).trafficSourceCode(resolvedTrafficSourceCode).usePmtRule(resolvedUsePaymentRule).build();
    }

    private static boolean shouldReplaceWithLegacyParameters(ExtImpAppnexus extImpAppnexus) {
        boolean setPlacementId = extImpAppnexus.getPlacementId() == null && extImpAppnexus.getDeprecatedPlacementId() != null;
        boolean setInvCode = extImpAppnexus.getInvCode() == null && extImpAppnexus.getLegacyInvCode() != null;
        boolean setTrafficSourceCode = extImpAppnexus.getTrafficSourceCode() == null && extImpAppnexus.getLegacyTrafficSourceCode() != null;
        return setPlacementId || setInvCode || setTrafficSourceCode;
    }

    private static void validateExtImpAppnexus(ExtImpAppnexus extImpAppnexus) {
        int placementId = (Integer)ObjectUtils.defaultIfNull((Object)extImpAppnexus.getPlacementId(), (Object)0);
        if (placementId == 0 && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{extImpAppnexus.getInvCode(), extImpAppnexus.getMember()})) {
            throw new PreBidException("No placement or member+invcode provided");
        }
    }

    private ObjectNode makeImpExt(ExtImpAppnexus appnexusExt) {
        AppnexusImpExtAppnexus appnexusImpExt = AppnexusImpExtAppnexus.builder().placementId(appnexusExt.getPlacementId()).keywords(AppnexusBidder.makeKeywords(appnexusExt.getKeywords())).trafficSourceCode(appnexusExt.getTrafficSourceCode()).usePmtRule(appnexusExt.getUsePmtRule()).privateSizes(appnexusExt.getPrivateSizes()).build();
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)AppnexusImpExt.of(appnexusImpExt));
    }

    private static String makeKeywords(List<AppnexusKeyVal> keywords) {
        String resolvedKeywords = CollectionUtils.emptyIfNull(keywords).stream().filter(entry -> entry.getKey() != null).flatMap(AppnexusBidder::extractKeywords).collect(Collectors.joining(","));
        return StringUtils.stripToNull((String)resolvedKeywords);
    }

    private static Stream<String> extractKeywords(AppnexusKeyVal appnexusKeyVal) {
        String key = appnexusKeyVal.getKey();
        List<String> values = appnexusKeyVal.getValue();
        return CollectionUtils.isNotEmpty(values) ? values.stream().map(value -> "%s=%s".formatted(key, value)) : Stream.of(key);
    }

    private static Banner makeBanner(Banner banner, ExtImpAppnexus appnexusExt) {
        if (banner == null) {
            return null;
        }
        Integer width = banner.getW();
        Integer height = banner.getH();
        List<Format> formats = banner.getFormat();
        Format firstFormat = CollectionUtils.isNotEmpty(formats) ? formats.get(0) : null;
        boolean replaceWithFirstFormat = firstFormat != null && width == null && height == null;
        Integer resolvedWidth = replaceWithFirstFormat ? firstFormat.getW() : width;
        Integer resolvedHeight = replaceWithFirstFormat ? firstFormat.getH() : height;
        Integer position = AppnexusBidder.resolvePosition(appnexusExt.getPosition());
        return position != null || replaceWithFirstFormat ? banner.toBuilder().pos(position).w(resolvedWidth).h(resolvedHeight).build() : banner;
    }

    private static Integer resolvePosition(String position) {
        Integer posAbove = Objects.equals(position, "above") ? Integer.valueOf(1) : null;
        Integer posBelow = Objects.equals(position, "below") ? Integer.valueOf(3) : null;
        return posAbove != null ? posAbove : posBelow;
    }

    private String constructUrl(Set<String> ids, List<BidderError> errors) {
        AppnexusBidder.validateMemberIds(ids, errors);
        return CollectionUtils.isNotEmpty(ids) ? "%s?member_id=%s".formatted(this.endpointUrl, ids.iterator().next()) : this.endpointUrl;
    }

    private static void validateMemberIds(Set<String> uniqueIds, List<BidderError> errors) {
        if (uniqueIds.size() > 1) {
            errors.add(BidderError.badInput("All request.imp[i].ext.appnexus.member params must match. Request contained: " + String.join((CharSequence)", ", uniqueIds)));
        }
    }

    private List<HttpRequest<BidRequest>> constructRequests(BidRequest bidRequest, List<Imp> imps, String url, Boolean generateAdPodId) {
        String requestEndpointName = AppnexusBidder.extractEndpointName(bidRequest);
        boolean isVideoRequest = StringUtils.equals((CharSequence)requestEndpointName, (CharSequence)Endpoint.openrtb2_video.value());
        boolean isAmpRequest = StringUtils.equals((CharSequence)requestEndpointName, (CharSequence)Endpoint.openrtb2_amp.value());
        return isVideoRequest && BooleanUtils.isTrue((Boolean)generateAdPodId) ? this.constructPodRequests(bidRequest, imps, url) : this.constructPartitionedRequests(bidRequest, imps, url, isVideoRequest, isAmpRequest);
    }

    private static String extractEndpointName(BidRequest bidRequest) {
        ExtRequest requestExt = bidRequest.getExt();
        ExtRequestPrebid prebid = requestExt != null ? requestExt.getPrebid() : null;
        ExtRequestPrebidServer server = prebid != null ? prebid.getServer() : null;
        return server != null ? server.getEndpoint() : null;
    }

    private List<HttpRequest<BidRequest>> constructPodRequests(BidRequest bidRequest, List<Imp> imps, String url) {
        return this.groupImpsByPod(imps).values().stream().map(podImps -> this.splitHttpRequests(bidRequest, this.updateRequestExtForVideo(bidRequest.getExt()), (List<Imp>)podImps, url)).flatMap(Collection::stream).toList();
    }

    private ExtRequest updateRequestExtForVideo(ExtRequest extRequest) {
        return this.updateRequestExt(extRequest, true, false, Long.toUnsignedString(this.rand.nextLong()));
    }

    private Map<String, List<Imp>> groupImpsByPod(List<Imp> processedImps) {
        return processedImps.stream().collect(Collectors.groupingBy(imp -> StringUtils.substringBefore((String)imp.getId(), (String)POD_SEPARATOR)));
    }

    private List<HttpRequest<BidRequest>> constructPartitionedRequests(BidRequest bidRequest, List<Imp> imps, String url, boolean isVideoRequest, boolean isAmpRequest) {
        ExtRequest updatedExtRequest = this.updateRequestExt(bidRequest.getExt(), isVideoRequest, isAmpRequest, null);
        return this.splitHttpRequests(bidRequest, updatedExtRequest, imps, url);
    }

    private ExtRequest updateRequestExt(ExtRequest extRequest, boolean isVideoRequest, boolean isAmpRequest, String adPodId) {
        Boolean includeBrandCategory = AppnexusBidder.isIncludeBrandCategory(extRequest);
        AppnexusReqExtAppnexus appnexus = AppnexusReqExtAppnexus.builder().includeBrandCategory(includeBrandCategory).brandCategoryUniqueness(includeBrandCategory).isAmp(BooleanUtils.toInteger((boolean)isAmpRequest)).adpodId(adPodId).headerBiddingSource(this.headerBiddingSource + BooleanUtils.toInteger((boolean)isVideoRequest)).build();
        ExtRequestPrebid extRequestPrebid = ObjectUtil.getIfNotNull(extRequest, ExtRequest::getPrebid);
        ObjectNode appnexusNode = (ObjectNode)this.mapper.mapper().createObjectNode().set("appnexus", this.mapper.mapper().valueToTree((Object)appnexus));
        return this.mapper.fillExtension(ExtRequest.of(extRequestPrebid), appnexusNode);
    }

    private static Boolean isIncludeBrandCategory(ExtRequest extRequest) {
        ExtRequestPrebid prebid = extRequest != null ? extRequest.getPrebid() : null;
        ExtRequestTargeting targeting = prebid != null ? prebid.getTargeting() : null;
        return targeting != null && targeting.getIncludebrandcategory() != null ? Boolean.valueOf(true) : null;
    }

    private List<HttpRequest<BidRequest>> splitHttpRequests(BidRequest bidRequest, ExtRequest requestExt, List<Imp> imps, String url) {
        return ListUtils.partition(imps, (int)10).stream().map(impsChunk -> this.createHttpRequest(bidRequest, requestExt, (List<Imp>)impsChunk, url)).toList();
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest bidRequest, ExtRequest requestExt, List<Imp> imps, String url) {
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(imps).ext(requestExt).build();
        return BidderUtil.defaultRequest(outgoingRequest, url, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(bidResponse, errors), errors);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.toBidderBid((Bid)bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid toBidderBid(Bid bid, String currency, List<BidderError> errors) {
        AppnexusBidExtAppnexus appnexus;
        try {
            appnexus = this.parseAppnexusBidExt(bid.getExt()).getAppnexus();
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
        if (appnexus == null) {
            errors.add(BidderError.badServerResponse("bidResponse.bid.ext.appnexus should be defined"));
            return null;
        }
        String iabCategory = this.iabCategory(appnexus.getBrandCategoryId());
        List<String> cat = bid.getCat();
        if (iabCategory != null) {
            cat = List.of(iabCategory);
        } else if (CollectionUtils.isNotEmpty(bid.getCat())) {
            cat = Collections.emptyList();
        }
        return BidderBid.builder().bid(bid.toBuilder().cat(cat).build()).type(AppnexusBidder.bidType(appnexus.getBidAdType())).bidCurrency(currency).dealPriority(appnexus.getDealPriority()).videoInfo(AppnexusBidder.makeExtBidVideo(appnexus)).build();
    }

    private static ExtBidPrebidVideo makeExtBidVideo(AppnexusBidExtAppnexus extAppnexus) {
        AppnexusBidExtCreative appnexusBidExtCreative = extAppnexus.getCreativeInfo();
        AppnexusBidExtVideo appnexusBidExtVideo = ObjectUtil.getIfNotNull(appnexusBidExtCreative, AppnexusBidExtCreative::getVideo);
        Integer duration = appnexusBidExtVideo != null ? appnexusBidExtVideo.getDuration() : null;
        return duration != null ? ExtBidPrebidVideo.of(duration, null) : null;
    }

    private String iabCategory(Integer brandId) {
        return brandId != null ? this.iabCategories.get(brandId) : null;
    }

    private static BidType bidType(Integer bidAdType) {
        if (bidAdType == null) {
            throw new PreBidException("bidResponse.bid.ext.appnexus.bid_ad_type should be defined");
        }
        return switch (bidAdType) {
            case 0 -> BidType.banner;
            case 1 -> BidType.video;
            case 2 -> BidType.audio;
            case 3 -> BidType.xNative;
            default -> throw new PreBidException("Unrecognized bid_ad_type in response from appnexus: " + bidAdType);
        };
    }

    private AppnexusBidExt parseAppnexusBidExt(ObjectNode bidExt) throws JsonProcessingException {
        if (bidExt == null) {
            throw new PreBidException("bidResponse.bid.ext should be defined for appnexus");
        }
        return (AppnexusBidExt)this.mapper.mapper().treeToValue((TreeNode)bidExt, AppnexusBidExt.class);
    }
}

