/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.MultiMap;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtAppPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.spring.config.bidder.model.CompressionType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.version.PrebidVersionProvider;

public class HttpBidderRequestEnricher {
    private static final Set<CharSequence> HEADERS_TO_COPY = Collections.singleton(HttpUtil.SEC_GPC_HEADER.toString());
    private final PrebidVersionProvider prebidVersionProvider;
    private final BidderCatalog bidderCatalog;

    public HttpBidderRequestEnricher(PrebidVersionProvider prebidVersionProvider, BidderCatalog bidderCatalog) {
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
    }

    MultiMap enrichHeaders(String bidderName, MultiMap bidderRequestHeaders, CaseInsensitiveMultiMap originalRequestHeaders, BidderAliases aliases, BidRequest bidRequest) {
        MultiMap bidderRequestHeadersCopy = HttpBidderRequestEnricher.copyMultiMap(bidderRequestHeaders);
        HttpBidderRequestEnricher.addOriginalRequestHeaders(bidderRequestHeadersCopy, originalRequestHeaders);
        this.addXPrebidHeader(bidderRequestHeadersCopy, bidRequest);
        HttpBidderRequestEnricher.addContentEncodingHeader(bidderRequestHeadersCopy, this.resolveCompressionType(bidderName, aliases));
        return bidderRequestHeadersCopy;
    }

    private static MultiMap copyMultiMap(MultiMap source) {
        MultiMap copiedMultiMap = MultiMap.caseInsensitiveMultiMap();
        if (source != null && !source.isEmpty()) {
            source.forEach(entry -> copiedMultiMap.add((String)entry.getKey(), (String)entry.getValue()));
        }
        return copiedMultiMap;
    }

    private static void addOriginalRequestHeaders(MultiMap bidderHeaders, CaseInsensitiveMultiMap originalHeaders) {
        originalHeaders.entries().stream().filter(entry -> HEADERS_TO_COPY.contains(entry.getKey()) && !bidderHeaders.contains((String)entry.getKey())).forEach(entry -> bidderHeaders.add((String)entry.getKey(), (String)entry.getValue()));
    }

    private void addXPrebidHeader(MultiMap headers, BidRequest bidRequest) {
        String channelRecord = HttpBidderRequestEnricher.resolveChannelVersionRecord(bidRequest.getExt());
        String sdkRecord = HttpBidderRequestEnricher.resolveSdkVersionRecord(bidRequest.getApp());
        String value = Stream.of(channelRecord, sdkRecord, this.prebidVersionProvider.getNameVersionRecord()).filter(Objects::nonNull).collect(Collectors.joining(","));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_PREBID_HEADER, value);
    }

    private static String resolveChannelVersionRecord(ExtRequest extRequest) {
        ExtRequestPrebid extPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ExtRequestPrebidChannel channel = extPrebid != null ? extPrebid.getChannel() : null;
        String channelName = channel != null ? channel.getName() : null;
        String channelVersion = channel != null ? channel.getVersion() : null;
        return HttpBidderRequestEnricher.createNameVersionRecord(channelName, channelVersion);
    }

    private static String resolveSdkVersionRecord(App app) {
        ExtApp extApp = app != null ? app.getExt() : null;
        ExtAppPrebid extPrebid = extApp != null ? extApp.getPrebid() : null;
        String sdkSource = extPrebid != null ? extPrebid.getSource() : null;
        String sdkVersion = extPrebid != null ? extPrebid.getVersion() : null;
        return HttpBidderRequestEnricher.createNameVersionRecord(sdkSource, sdkVersion);
    }

    private static String createNameVersionRecord(String name, String version) {
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{name, version}) ? "%s/%s".formatted(name, version) : null;
    }

    private static void addContentEncodingHeader(MultiMap bidderHeaders, CompressionType compressionType) {
        if (compressionType == CompressionType.GZIP) {
            bidderHeaders.add(HttpUtil.CONTENT_ENCODING_HEADER, (CharSequence)HttpHeaderValues.GZIP);
        }
    }

    private CompressionType resolveCompressionType(String bidderName, BidderAliases aliases) {
        return Optional.ofNullable(this.bidderCatalog.bidderInfoByName(aliases.resolveBidder(bidderName))).map(BidderInfo::getCompressionType).orElse(CompressionType.NONE);
    }
}

