/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;

public class DisabledBidder
implements Bidder<Void> {
    private final String errorMessage;

    public DisabledBidder(String errorMessage) {
        this.errorMessage = Objects.requireNonNull(errorMessage);
    }

    @Override
    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest request) {
        return Result.withError(BidderError.badInput(this.errorMessage));
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> extractTargeting(ObjectNode ext) {
        throw new UnsupportedOperationException();
    }
}

