/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Pmp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.BidderRequestCompletionTracker;
import org.prebid.server.bidder.BidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.model.BidderBid;

public class DealsBidderRequestCompletionTrackerFactory
implements BidderRequestCompletionTrackerFactory {
    @Override
    public BidderRequestCompletionTracker create(BidRequest bidRequest) {
        HashMap<String, String> impToTopDealMap = new HashMap<String, String>();
        for (Imp imp : bidRequest.getImp()) {
            Pmp pmp = imp.getPmp();
            List<Deal> deals = pmp != null ? pmp.getDeals() : null;
            Deal topDeal = CollectionUtils.isNotEmpty(deals) ? deals.get(0) : null;
            impToTopDealMap.put(imp.getId(), topDeal != null ? topDeal.getId() : null);
        }
        return !impToTopDealMap.containsValue(null) ? new TopDealsReceivedTracker(impToTopDealMap) : new NeverCompletedTracker();
    }

    private static class TopDealsReceivedTracker
    implements BidderRequestCompletionTracker {
        private final Map<String, String> impToTopDealMap;
        private final Promise<Void> completionPromise;

        private TopDealsReceivedTracker(Map<String, String> impToTopDealMap) {
            this.impToTopDealMap = new HashMap<String, String>(impToTopDealMap);
            this.completionPromise = Promise.promise();
        }

        @Override
        public Future<Void> future() {
            return this.completionPromise.future();
        }

        @Override
        public void processBids(List<BidderBid> bids) {
            if (this.completionPromise.future().isComplete()) {
                return;
            }
            bids.stream().map(BidderBid::getBid).filter(Objects::nonNull).map(this::toImpIdIfTopDeal).filter(Objects::nonNull).forEach(this.impToTopDealMap::remove);
            if (this.impToTopDealMap.isEmpty()) {
                this.completionPromise.tryComplete();
            }
        }

        private String toImpIdIfTopDeal(Bid bid) {
            String topDealForImp;
            String dealId;
            String impId = bid.getImpid();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{impId, dealId = bid.getDealid()}) && (topDealForImp = this.impToTopDealMap.get(impId)) != null && Objects.equals(dealId, topDealForImp)) {
                return impId;
            }
            return null;
        }
    }

    private static class NeverCompletedTracker
    implements BidderRequestCompletionTracker {
        private NeverCompletedTracker() {
        }

        @Override
        public Future<Void> future() {
            return Future.failedFuture((String)"No deals to wait for");
        }

        @Override
        public void processBids(List<BidderBid> bids) {
        }
    }
}

