/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.versionconverter.down;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Audio;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Producer;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConverter;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;

public class BidRequestOrtb26To25Converter
implements BidRequestOrtbVersionConverter {
    private static final String PREBID_FIELD = "prebid";
    private static final String IS_REWARDED_INVENTORY_FIELD = "is_rewarded_inventory";
    private static final Producer EMPTY_PRODUCER = Producer.builder().build();
    private static final Publisher EMPTY_PUBLISHER = Publisher.builder().build();
    private final JacksonMapper mapper;

    public BidRequestOrtb26To25Converter(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public BidRequest convert(BidRequest bidRequest) {
        List<Imp> imps = bidRequest.getImp();
        List<Imp> modifiedImps = this.modifyImps(imps);
        Site site = bidRequest.getSite();
        Site modifiedSite = BidRequestOrtb26To25Converter.modifySite(site);
        App app = bidRequest.getApp();
        App modifiedApp = BidRequestOrtb26To25Converter.modifyApp(app);
        Device device = bidRequest.getDevice();
        Device modifiedDevice = BidRequestOrtb26To25Converter.modifyDevice(device);
        User user = bidRequest.getUser();
        User modifiedUser = BidRequestOrtb26To25Converter.modifyUser(user);
        Source source = bidRequest.getSource();
        Source modifiedSource = BidRequestOrtb26To25Converter.modifySource(source);
        Regs regs = bidRequest.getRegs();
        Regs modifiedRegs = BidRequestOrtb26To25Converter.modifyRegs(regs);
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedImps, modifiedSite, modifiedApp, modifiedDevice, modifiedUser, bidRequest.getWlangb(), bidRequest.getCattax(), bidRequest.getDooh(), modifiedSource, modifiedRegs}) ? bidRequest.toBuilder().imp(modifiedImps != null ? modifiedImps : imps).site(modifiedSite != null ? modifiedSite : site).app(modifiedApp != null ? modifiedApp : app).device(modifiedDevice != null ? modifiedDevice : device).user(modifiedUser != null ? modifiedUser : user).wlangb(null).cattax(null).dooh(null).source(modifiedSource != null ? modifiedSource : source).regs(modifiedRegs != null ? modifiedRegs : regs).build() : bidRequest;
    }

    private List<Imp> modifyImps(List<Imp> imps) {
        List<Imp> modifiedImps = imps.stream().map(this::modifyImp).toList();
        if (modifiedImps.stream().allMatch(Objects::isNull)) {
            return null;
        }
        return IntStream.range(0, imps.size()).mapToObj(i -> (Imp)ObjectUtils.defaultIfNull((Object)((Imp)modifiedImps.get(i)), (Object)((Imp)imps.get(i)))).toList();
    }

    private Imp modifyImp(Imp imp) {
        Video video = imp.getVideo();
        Video modifiedVideo = BidRequestOrtb26To25Converter.modifyVideo(video);
        Audio audio = imp.getAudio();
        Audio modifiedAudio = BidRequestOrtb26To25Converter.modifyAudio(audio);
        ObjectNode impExt = imp.getExt();
        ObjectNode modifiedImpExt = this.modifyImpExt(impExt, imp.getRwdd());
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedVideo, modifiedAudio, imp.getSsai(), imp.getQty(), imp.getDt(), imp.getRefresh(), modifiedImpExt}) ? imp.toBuilder().video(modifiedVideo != null ? modifiedVideo : video).audio(modifiedAudio != null ? modifiedAudio : audio).rwdd(null).ssai(null).qty(null).dt(null).refresh(null).ext(modifiedImpExt != null ? modifiedImpExt : impExt).build() : null;
    }

    private static Video modifyVideo(Video video) {
        if (video == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{video.getMaxseq(), video.getPoddur(), video.getPodid(), video.getPodseq(), video.getRqddurs(), video.getSlotinpod(), video.getMincpmpersec(), video.getPlcmt()}) ? video.toBuilder().maxseq(null).poddur(null).podid(null).podseq(null).rqddurs(null).slotinpod(null).mincpmpersec(null).plcmt(null).build() : null;
    }

    private static Audio modifyAudio(Audio audio) {
        if (audio == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{audio.getPoddur(), audio.getRqddurs(), audio.getPodid(), audio.getPodseq(), audio.getSlotinpod(), audio.getMincpmpersec(), audio.getMaxseq()}) ? audio.toBuilder().poddur(null).rqddurs(null).podid(null).podseq(null).slotinpod(null).mincpmpersec(null).maxseq(null).build() : null;
    }

    private ObjectNode modifyImpExt(ObjectNode impExt, Integer rewarded) {
        if (rewarded == null) {
            return null;
        }
        ObjectNode copy = Optional.ofNullable(impExt).map(ObjectNode::deepCopy).orElseGet(() -> ((ObjectMapper)this.mapper.mapper()).createObjectNode());
        JsonNode prebidNode = copy.get(PREBID_FIELD);
        if (prebidNode == null || !prebidNode.isObject()) {
            prebidNode = this.mapper.mapper().createObjectNode();
            copy.set(PREBID_FIELD, prebidNode);
        }
        ((ObjectNode)prebidNode).put(IS_REWARDED_INVENTORY_FIELD, rewarded);
        return copy;
    }

    private static Site modifySite(Site site) {
        if (site == null) {
            return null;
        }
        Publisher publisher = site.getPublisher();
        Publisher modifiedPublisher = BidRequestOrtb26To25Converter.modifyPublisher(publisher);
        Content content = site.getContent();
        Content modifiedContent = BidRequestOrtb26To25Converter.modifyContent(content);
        return ObjectUtils.anyNotNull((Object[])new Object[]{site.getCattax(), site.getInventorypartnerdomain(), modifiedPublisher, modifiedContent, site.getKwarray()}) ? site.toBuilder().cattax(null).inventorypartnerdomain(null).publisher(modifiedPublisher != null ? BidRequestOrtb26To25Converter.nullIfEmpty(modifiedPublisher) : publisher).content(modifiedContent != null ? BidRequestOrtb26To25Converter.nullIfEmpty(modifiedContent) : content).kwarray(null).build() : null;
    }

    private static Publisher modifyPublisher(Publisher publisher) {
        return publisher != null && publisher.getCattax() != null ? publisher.toBuilder().cattax(null).build() : null;
    }

    private static Content modifyContent(Content content) {
        if (content == null) {
            return null;
        }
        Producer producer = content.getProducer();
        Producer modifiedProducer = BidRequestOrtb26To25Converter.modifyProducer(producer);
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedProducer, content.getCattax(), content.getKwarray(), content.getLangb(), content.getNetwork(), content.getChannel()}) ? content.toBuilder().producer(modifiedProducer != null ? BidRequestOrtb26To25Converter.nullIfEmpty(modifiedProducer) : producer).cattax(null).kwarray(null).langb(null).network(null).channel(null).build() : null;
    }

    private static Producer modifyProducer(Producer producer) {
        return producer != null && producer.getCattax() != null ? producer.toBuilder().cattax(null).build() : null;
    }

    private static Producer nullIfEmpty(Producer producer) {
        return BidRequestOrtb26To25Converter.nullIfEmpty(producer, EMPTY_PRODUCER.equals(producer));
    }

    private static Publisher nullIfEmpty(Publisher publisher) {
        return BidRequestOrtb26To25Converter.nullIfEmpty(publisher, EMPTY_PUBLISHER.equals(publisher));
    }

    private static Content nullIfEmpty(Content content) {
        return BidRequestOrtb26To25Converter.nullIfEmpty(content, content.isEmpty());
    }

    private static <T> T nullIfEmpty(T object, boolean isEmpty) {
        return isEmpty ? null : (T)object;
    }

    private static App modifyApp(App app) {
        if (app == null) {
            return null;
        }
        Publisher publisher = app.getPublisher();
        Publisher modifiedPublisher = BidRequestOrtb26To25Converter.modifyPublisher(publisher);
        Content content = app.getContent();
        Content modifiedContent = BidRequestOrtb26To25Converter.modifyContent(content);
        return ObjectUtils.anyNotNull((Object[])new Object[]{app.getCattax(), app.getInventorypartnerdomain(), modifiedPublisher, modifiedContent, app.getKwarray()}) ? app.toBuilder().cattax(null).inventorypartnerdomain(null).publisher(modifiedPublisher != null ? BidRequestOrtb26To25Converter.nullIfEmpty(modifiedPublisher) : publisher).content(modifiedContent != null ? BidRequestOrtb26To25Converter.nullIfEmpty(modifiedContent) : content).kwarray(null).build() : null;
    }

    private static Device modifyDevice(Device device) {
        if (device == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{device.getSua(), device.getLangb()}) ? device.toBuilder().sua(null).langb(null).build() : null;
    }

    private static User modifyUser(User user) {
        if (user == null) {
            return null;
        }
        ExtUser extUser = user.getExt();
        ExtUser modifiedExtUser = BidRequestOrtb26To25Converter.modifyUserExt(extUser, user.getConsent(), user.getEids());
        return ObjectUtils.anyNotNull((Object[])new Object[]{user.getKwarray(), modifiedExtUser}) ? user.toBuilder().kwarray(null).consent(null).eids(null).ext(modifiedExtUser != null ? modifiedExtUser : extUser).build() : null;
    }

    private static ExtUser modifyUserExt(ExtUser extUser, String consent, List<Eid> eids) {
        if (consent == null && CollectionUtils.isEmpty(eids)) {
            return null;
        }
        ExtUser modifiedExtUser = Optional.ofNullable(extUser).map(ExtUser::toBuilder).orElseGet(ExtUser::builder).consent(consent).eids(eids).build();
        BidRequestOrtb26To25Converter.copyProperties(extUser, modifiedExtUser);
        return modifiedExtUser;
    }

    private static void copyProperties(FlexibleExtension source, FlexibleExtension target) {
        Optional.ofNullable(source).map(FlexibleExtension::getProperties).ifPresent(target::addProperties);
    }

    private static Source modifySource(Source source) {
        if (source == null) {
            return null;
        }
        SupplyChain supplyChain = source.getSchain();
        if (supplyChain == null) {
            return null;
        }
        ExtSource extSource = ExtSource.of(supplyChain);
        BidRequestOrtb26To25Converter.copyProperties(source.getExt(), extSource);
        return source.toBuilder().schain(null).ext(extSource).build();
    }

    private static Regs modifyRegs(Regs regs) {
        if (regs == null) {
            return null;
        }
        Integer gdpr = regs.getGdpr();
        String usPrivacy = regs.getUsPrivacy();
        String gpp = regs.getGpp();
        List<Integer> gppSid = regs.getGppSid();
        if (gdpr == null && usPrivacy == null && gpp == null && gppSid == null) {
            return null;
        }
        ExtRegs originalExtRegs = regs.getExt();
        String gpc = originalExtRegs != null ? originalExtRegs.getGpc() : null;
        ExtRegs extRegs = ExtRegs.of(gdpr, usPrivacy, gpc);
        BidRequestOrtb26To25Converter.copyProperties(originalExtRegs, extRegs);
        return regs.toBuilder().gdpr(null).usPrivacy(null).gpp(null).gppSid(null).ext(extRegs).build();
    }
}

