/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp.processor.uspv1;

import com.iab.gpp.encoder.GppModel;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.section.UspV1;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.UspV1Privacy;
import org.prebid.server.auction.gpp.processor.GppContextProcessor;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.model.UpdateResult;

public class UspV1ContextProcessor
implements GppContextProcessor {
    @Override
    public GppContextWrapper process(GppContext gppContext) {
        ArrayList<String> errors = new ArrayList<String>();
        return GppContextWrapper.of(UspV1ContextProcessor.process(gppContext, errors), errors);
    }

    private static GppContext process(GppContext gppContext, List<String> errors) {
        GppContext.Scope scope = gppContext.scope();
        UspV1Privacy uspV1Privacy = gppContext.regions().getUspV1Privacy();
        UpdateResult<String> resolvedUsPrivacy = UspV1ContextProcessor.resolveUsPrivacy(uspV1Privacy != null ? uspV1Privacy.getUsPrivacy() : null, scope.getGppModel(), scope.getSectionsIds(), errors);
        return resolvedUsPrivacy.isUpdated() ? gppContext.with(UspV1Privacy.of(resolvedUsPrivacy.getValue())) : gppContext;
    }

    private static UpdateResult<String> resolveUsPrivacy(String usPrivacy, GppModel gppModel, Set<Integer> sectionsIds, List<String> errors) {
        if (!UspV1ContextProcessor.isValidScope(gppModel, sectionsIds)) {
            return UpdateResult.unaltered(usPrivacy);
        }
        if (usPrivacy == null) {
            return UpdateResult.updated(UspV1ContextProcessor.usPrivacyFromGpp(gppModel));
        }
        try {
            UspV1ContextProcessor.validateExistingUsPrivacy(usPrivacy, gppModel);
        }
        catch (PreBidException e) {
            errors.add(e.getMessage());
        }
        return UpdateResult.unaltered(usPrivacy);
    }

    private static boolean isValidScope(GppModel gppModel, Set<Integer> sectionsIds) {
        return sectionsIds != null && sectionsIds.contains(UspV1.ID) && gppModel != null && gppModel.hasSection(UspV1.ID);
    }

    private static String usPrivacyFromGpp(GppModel gppModel) {
        try {
            return gppModel.encodeSection(UspV1.ID);
        }
        catch (EncodingException e) {
            return null;
        }
    }

    private static void validateExistingUsPrivacy(String usPrivacy, GppModel gppModel) {
        if (!usPrivacy.equals(UspV1ContextProcessor.usPrivacyFromGpp(gppModel))) {
            throw new PreBidException("USP string does not match regs.us_privacy");
        }
    }
}

