/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp.model;

import com.iab.gpp.encoder.GppModel;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.prebid.server.auction.gpp.model.GppContextUtils;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.auction.gpp.model.privacy.TcfEuV2Privacy;
import org.prebid.server.auction.gpp.model.privacy.UspV1Privacy;

public record GppContext(Scope scope, Regions regions) {
    public GppContext with(Privacy privacy) {
        return new GppContext(this.scope, GppContextUtils.withPrivacy(this.regions, privacy));
    }

    public static final class Scope {
        private final GppModel gppModel;
        private final Set<Integer> sectionsIds;

        @ConstructorProperties(value={"gppModel", "sectionsIds"})
        private Scope(GppModel gppModel, Set<Integer> sectionsIds) {
            this.gppModel = gppModel;
            this.sectionsIds = sectionsIds;
        }

        public static Scope of(GppModel gppModel, Set<Integer> sectionsIds) {
            return new Scope(gppModel, sectionsIds);
        }

        public GppModel getGppModel() {
            return this.gppModel;
        }

        public Set<Integer> getSectionsIds() {
            return this.sectionsIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scope)) {
                return false;
            }
            Scope other = (Scope)o;
            GppModel this$gppModel = this.getGppModel();
            GppModel other$gppModel = other.getGppModel();
            if (this$gppModel == null ? other$gppModel != null : !this$gppModel.equals(other$gppModel)) {
                return false;
            }
            Set<Integer> this$sectionsIds = this.getSectionsIds();
            Set<Integer> other$sectionsIds = other.getSectionsIds();
            return !(this$sectionsIds == null ? other$sectionsIds != null : !((Object)this$sectionsIds).equals(other$sectionsIds));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GppModel $gppModel = this.getGppModel();
            result = result * 59 + ($gppModel == null ? 43 : $gppModel.hashCode());
            Set<Integer> $sectionsIds = this.getSectionsIds();
            result = result * 59 + ($sectionsIds == null ? 43 : ((Object)$sectionsIds).hashCode());
            return result;
        }

        public String toString() {
            return "GppContext.Scope(gppModel=" + this.getGppModel() + ", sectionsIds=" + this.getSectionsIds() + ")";
        }
    }

    public static final class Regions {
        private final TcfEuV2Privacy tcfEuV2Privacy;
        private final UspV1Privacy uspV1Privacy;

        @ConstructorProperties(value={"tcfEuV2Privacy", "uspV1Privacy"})
        Regions(TcfEuV2Privacy tcfEuV2Privacy, UspV1Privacy uspV1Privacy) {
            this.tcfEuV2Privacy = tcfEuV2Privacy;
            this.uspV1Privacy = uspV1Privacy;
        }

        public static RegionsBuilder builder() {
            return new RegionsBuilder();
        }

        public RegionsBuilder toBuilder() {
            return new RegionsBuilder().tcfEuV2Privacy(this.tcfEuV2Privacy).uspV1Privacy(this.uspV1Privacy);
        }

        public TcfEuV2Privacy getTcfEuV2Privacy() {
            return this.tcfEuV2Privacy;
        }

        public UspV1Privacy getUspV1Privacy() {
            return this.uspV1Privacy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Regions)) {
                return false;
            }
            Regions other = (Regions)o;
            TcfEuV2Privacy this$tcfEuV2Privacy = this.getTcfEuV2Privacy();
            TcfEuV2Privacy other$tcfEuV2Privacy = other.getTcfEuV2Privacy();
            if (this$tcfEuV2Privacy == null ? other$tcfEuV2Privacy != null : !((Object)this$tcfEuV2Privacy).equals(other$tcfEuV2Privacy)) {
                return false;
            }
            UspV1Privacy this$uspV1Privacy = this.getUspV1Privacy();
            UspV1Privacy other$uspV1Privacy = other.getUspV1Privacy();
            return !(this$uspV1Privacy == null ? other$uspV1Privacy != null : !((Object)this$uspV1Privacy).equals(other$uspV1Privacy));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TcfEuV2Privacy $tcfEuV2Privacy = this.getTcfEuV2Privacy();
            result = result * 59 + ($tcfEuV2Privacy == null ? 43 : ((Object)$tcfEuV2Privacy).hashCode());
            UspV1Privacy $uspV1Privacy = this.getUspV1Privacy();
            result = result * 59 + ($uspV1Privacy == null ? 43 : ((Object)$uspV1Privacy).hashCode());
            return result;
        }

        public String toString() {
            return "GppContext.Regions(tcfEuV2Privacy=" + this.getTcfEuV2Privacy() + ", uspV1Privacy=" + this.getUspV1Privacy() + ")";
        }

        public static class RegionsBuilder {
            private TcfEuV2Privacy tcfEuV2Privacy;
            private UspV1Privacy uspV1Privacy;

            RegionsBuilder() {
            }

            public RegionsBuilder tcfEuV2Privacy(TcfEuV2Privacy tcfEuV2Privacy) {
                this.tcfEuV2Privacy = tcfEuV2Privacy;
                return this;
            }

            public RegionsBuilder uspV1Privacy(UspV1Privacy uspV1Privacy) {
                this.uspV1Privacy = uspV1Privacy;
                return this;
            }

            public Regions build() {
                return new Regions(this.tcfEuV2Privacy, this.uspV1Privacy);
            }

            public String toString() {
                return "GppContext.Regions.RegionsBuilder(tcfEuV2Privacy=" + this.tcfEuV2Privacy + ", uspV1Privacy=" + this.uspV1Privacy + ")";
            }
        }
    }
}

