/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp;

import io.vertx.core.Future;
import java.util.List;
import java.util.Objects;
import org.prebid.server.auction.gpp.GppService;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.TcfEuV2Privacy;
import org.prebid.server.auction.model.SetuidContext;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.privacy.model.PrivacyContext;

public class SetuidGppService {
    private final GppService gppService;

    public SetuidGppService(GppService gppService) {
        this.gppService = Objects.requireNonNull(gppService);
    }

    public Future<GppContext> contextFrom(SetuidContext setuidContext) {
        GppContextWrapper initialGppContextWrapper = SetuidGppService.contextFrom(setuidContext.getPrivacyContext());
        GppContextWrapper gppContextWrapper = this.gppService.processContext(initialGppContextWrapper);
        return Future.succeededFuture((Object)gppContextWrapper.getGppContext());
    }

    private static GppContextWrapper contextFrom(PrivacyContext privacyContext) {
        Privacy privacy = privacyContext.getPrivacy();
        String gpp = privacy.getGpp();
        List<Integer> gppSid = privacy.getGppSid();
        Integer gdpr = SetuidGppService.toInt(privacy.getGdpr());
        String consent = privacy.getConsentString();
        return GppContextCreator.from(gpp, gppSid).with(TcfEuV2Privacy.of(gdpr, consent)).build();
    }

    private static Integer toInt(String string) {
        try {
            return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public SetuidContext updateSetuidContext(SetuidContext setuidContext) {
        GppContext gppContext = setuidContext.getGppContext();
        PrivacyContext privacyContext = setuidContext.getPrivacyContext();
        Privacy privacy = privacyContext.getPrivacy();
        GppContext.Regions regions = gppContext.regions();
        TcfEuV2Privacy tcfEuV2Privacy = regions.getTcfEuV2Privacy();
        UpdateResult<Integer> updatedGdpr = SetuidGppService.updateResult(SetuidGppService.toInt(privacy.getGdpr()), tcfEuV2Privacy != null ? tcfEuV2Privacy.getGdpr() : null);
        UpdateResult<String> updatedConsent = SetuidGppService.updateResult(privacy.getConsentString(), tcfEuV2Privacy != null ? tcfEuV2Privacy.getConsent() : null);
        return updatedGdpr.isUpdated() || updatedConsent.isUpdated() ? setuidContext.toBuilder().privacyContext(PrivacyContext.of(privacy.toBuilder().gdpr(updatedGdpr.getValue().toString()).consentString(updatedConsent.getValue()).build(), privacyContext.getTcfContext(), privacyContext.getIpAddress())).build() : setuidContext;
    }

    private static <T> UpdateResult<T> updateResult(T original, T gpp) {
        return original == null && gpp != null ? UpdateResult.updated(gpp) : UpdateResult.unaltered(original);
    }
}

