/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.video.PodError;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.identity.IdGenerator;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.ExtAdPod;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponsePrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidderError;
import org.prebid.server.proto.openrtb.ext.response.ExtModules;
import org.prebid.server.proto.openrtb.ext.response.ExtResponseDebug;
import org.prebid.server.proto.openrtb.ext.response.ExtResponseVideoTargeting;
import org.prebid.server.proto.response.ExtAmpVideoPrebid;
import org.prebid.server.proto.response.ExtAmpVideoResponse;
import org.prebid.server.proto.response.VideoResponse;

public class VideoResponseFactory {
    public static final String PREBID_EXT = "prebid";
    private final IdGenerator idGenerator;
    private final JacksonMapper mapper;

    public VideoResponseFactory(IdGenerator idGenerator, JacksonMapper mapper) {
        this.idGenerator = idGenerator;
        this.mapper = mapper;
    }

    public VideoResponse toVideoResponse(AuctionContext auctionContext, BidResponse bidResponse, List<PodError> podErrors) {
        List<Bid> bids = VideoResponseFactory.bidsFrom(bidResponse);
        boolean anyBidsReturned = CollectionUtils.isNotEmpty(bids);
        List<ExtAdPod> adPods = this.adPodsWithTargetingFrom(bids);
        CachedDebugLog cachedDebugLog = auctionContext.getCachedDebugLog();
        if (VideoResponseFactory.cachedDebugEnabled(cachedDebugLog) && CollectionUtils.isEmpty(adPods)) {
            String cacheId = this.idGenerator.generateId();
            cachedDebugLog.setCacheKey(cacheId);
            cachedDebugLog.setHasBids(false);
            adPods.add(ExtAdPod.of(null, Collections.singletonList(ExtResponseVideoTargeting.of(null, null, cacheId)), null));
        }
        if (anyBidsReturned && CollectionUtils.isEmpty(adPods)) {
            throw new PreBidException("caching failed for all bids");
        }
        adPods.addAll(VideoResponseFactory.adPodsWithErrors(podErrors));
        return VideoResponse.of(adPods, VideoResponseFactory.extResponseFrom(bidResponse));
    }

    private static List<Bid> bidsFrom(BidResponse bidResponse) {
        if (bidResponse != null && CollectionUtils.isNotEmpty(bidResponse.getSeatbid())) {
            return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        }
        return Collections.emptyList();
    }

    private List<ExtAdPod> adPodsWithTargetingFrom(List<Bid> bids) {
        ArrayList<ExtAdPod> adPods = new ArrayList<ExtAdPod>();
        for (Bid bid : bids) {
            String impId;
            String podIdString;
            Map<String, String> targeting = this.targeting(bid);
            if (VideoResponseFactory.findByPrefix(targeting, "hb_uuid") == null || !NumberUtils.isDigits((String)(podIdString = (impId = bid.getImpid()).split("_")[0]))) continue;
            Integer podId = Integer.parseInt(podIdString);
            ExtResponseVideoTargeting videoTargeting = ExtResponseVideoTargeting.of(VideoResponseFactory.findByPrefix(targeting, "hb_pb"), VideoResponseFactory.findByPrefix(targeting, "hb_pb_cat_dur"), VideoResponseFactory.findByPrefix(targeting, "hb_uuid"));
            ExtAdPod adPod = adPods.stream().filter(extAdPod -> extAdPod.getPodid().equals(podId)).findFirst().orElse(null);
            if (adPod == null) {
                adPod = ExtAdPod.of(podId, new ArrayList<ExtResponseVideoTargeting>(), null);
                adPods.add(adPod);
            }
            adPod.getTargeting().add(videoTargeting);
        }
        return adPods;
    }

    private Map<String, String> targeting(Bid bid) {
        ExtBidPrebid extBidPrebid;
        ObjectNode bidExt = bid.getExt();
        if (bidExt == null || !bidExt.hasNonNull(PREBID_EXT)) {
            return Collections.emptyMap();
        }
        try {
            extBidPrebid = (ExtBidPrebid)this.mapper.mapper().convertValue((Object)bidExt.get(PREBID_EXT), ExtBidPrebid.class);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyMap();
        }
        Map<String, String> targeting = extBidPrebid != null ? extBidPrebid.getTargeting() : null;
        return targeting != null ? targeting : Collections.emptyMap();
    }

    private static String findByPrefix(Map<String, String> keyToValue, String prefix) {
        return keyToValue.entrySet().stream().filter(keyAndValue -> ((String)keyAndValue.getKey()).startsWith(prefix)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static List<ExtAdPod> adPodsWithErrors(List<PodError> podErrors) {
        return podErrors.stream().map(podError -> ExtAdPod.of(podError.getPodId(), null, podError.getPodErrors())).toList();
    }

    private static ExtAmpVideoResponse extResponseFrom(BidResponse bidResponse) {
        ExtBidResponse ext = bidResponse.getExt();
        ExtBidResponsePrebid extPrebid = ext != null ? ext.getPrebid() : null;
        ExtResponseDebug extDebug = ext != null ? ext.getDebug() : null;
        Map<String, List<ExtBidderError>> extErrors = ext != null ? ext.getErrors() : null;
        Map<String, List<ExtBidderError>> extWarnings = ext != null ? ext.getWarnings() : null;
        ExtModules extModules = extPrebid != null ? extPrebid.getModules() : null;
        ExtAmpVideoPrebid extAmpVideoPrebid = extModules != null ? ExtAmpVideoPrebid.of(extModules) : null;
        return ObjectUtils.anyNotNull((Object[])new Object[]{extDebug, extErrors, extWarnings, extAmpVideoPrebid}) ? ExtAmpVideoResponse.of(extDebug, extErrors, extWarnings, extAmpVideoPrebid) : null;
    }

    private static boolean cachedDebugEnabled(CachedDebugLog cachedDebugLog) {
        return cachedDebugLog != null && cachedDebugLog.isEnabled();
    }
}

