/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.response.Bid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.CpmRange;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.TargetingKeywordsResolver;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;

public class TargetingKeywordsCreator {
    private static final String HB_ENV_KEY = "hb_env";
    private static final String HB_ENV_APP_VALUE = "mobile-app";
    private static final String HB_BIDDER_KEY = "hb_bidder";
    private static final String HB_PB_KEY = "hb_pb";
    private static final String HB_SIZE_KEY = "hb_size";
    private static final String HB_CACHE_ID_KEY = "hb_cache_id";
    private static final String HB_VAST_ID_KEY = "hb_uuid";
    private static final String HB_DEAL_KEY = "hb_deal";
    private static final String HB_CACHE_HOST_KEY = "hb_cache_host";
    private static final String HB_CACHE_PATH_KEY = "hb_cache_path";
    private static final String HB_CATEGORY_DURATION_KEY = "hb_pb_cat_dur";
    private static final String HB_FORMAT_KEY = "hb_format";
    private static final String DEFAULT_CPM = "0.0";
    private final PriceGranularity priceGranularity;
    private final boolean includeWinners;
    private final boolean includeBidderKeys;
    private final boolean alwaysIncludeDeals;
    private final boolean includeFormat;
    private final boolean isApp;
    private final int truncateAttrChars;
    private final String cacheHost;
    private final String cachePath;
    private final TargetingKeywordsResolver resolver;

    private TargetingKeywordsCreator(PriceGranularity priceGranularity, boolean includeWinners, boolean includeBidderKeys, boolean alwaysIncludeDeals, boolean includeFormat, boolean isApp, int truncateAttrChars, String cacheHost, String cachePath, TargetingKeywordsResolver resolver) {
        this.priceGranularity = priceGranularity;
        this.includeWinners = includeWinners;
        this.includeBidderKeys = includeBidderKeys;
        this.alwaysIncludeDeals = alwaysIncludeDeals;
        this.includeFormat = includeFormat;
        this.isApp = isApp;
        this.truncateAttrChars = truncateAttrChars;
        this.cacheHost = cacheHost;
        this.cachePath = cachePath;
        this.resolver = resolver;
    }

    public static TargetingKeywordsCreator create(ExtPriceGranularity extPriceGranularity, boolean includeWinners, boolean includeBidderKeys, boolean alwaysIncludeDeals, boolean includeFormat, boolean isApp, int truncateAttrChars, String cacheHost, String cachePath, TargetingKeywordsResolver resolver) {
        return new TargetingKeywordsCreator(PriceGranularity.createFromExtPriceGranularity(extPriceGranularity), includeWinners, includeBidderKeys, alwaysIncludeDeals, includeFormat, isApp, truncateAttrChars, cacheHost, cachePath, resolver);
    }

    Map<String, String> makeFor(Bid bid, String bidder, boolean winningBid, String cacheId, String format, String vastCacheId, String categoryDuration) {
        Map<String, String> keywords = this.makeFor(bidder, winningBid, bid.getPrice(), bid.getW(), bid.getH(), cacheId, vastCacheId, categoryDuration, format, bid.getDealid());
        if (this.resolver == null) {
            return this.truncateKeys(keywords);
        }
        HashMap<String, String> augmentedKeywords = new HashMap<String, String>(keywords);
        augmentedKeywords.putAll(this.resolver.resolve(bid, bidder));
        return this.truncateKeys(augmentedKeywords);
    }

    private Map<String, String> makeFor(String bidder, boolean winningBid, BigDecimal price, Integer width, Integer height, String cacheId, String vastCacheId, String categoryDuration, String format, String dealId) {
        boolean includeDealBid = this.alwaysIncludeDeals && StringUtils.isNotEmpty((CharSequence)dealId);
        KeywordMap keywordMap = new KeywordMap(bidder, winningBid, this.includeWinners, this.includeBidderKeys || includeDealBid, Collections.emptySet());
        String roundedCpm = this.isPriceGranularityValid() ? CpmRange.fromCpm(price, this.priceGranularity) : DEFAULT_CPM;
        keywordMap.put(HB_PB_KEY, roundedCpm);
        keywordMap.put(HB_BIDDER_KEY, bidder);
        String hbSize = TargetingKeywordsCreator.sizeFrom(width, height);
        if (hbSize != null) {
            keywordMap.put(HB_SIZE_KEY, hbSize);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheId)) {
            keywordMap.put(HB_CACHE_ID_KEY, cacheId);
        }
        if (StringUtils.isNotBlank((CharSequence)vastCacheId)) {
            keywordMap.put(HB_VAST_ID_KEY, vastCacheId);
        }
        if ((StringUtils.isNotBlank((CharSequence)vastCacheId) || StringUtils.isNotBlank((CharSequence)cacheId)) && this.cacheHost != null && this.cachePath != null) {
            keywordMap.put(HB_CACHE_HOST_KEY, this.cacheHost);
            keywordMap.put(HB_CACHE_PATH_KEY, this.cachePath);
        }
        if (StringUtils.isNotBlank((CharSequence)format) && this.includeFormat) {
            keywordMap.put(HB_FORMAT_KEY, format);
        }
        if (StringUtils.isNotBlank((CharSequence)dealId)) {
            keywordMap.put(HB_DEAL_KEY, dealId);
        }
        if (this.isApp) {
            keywordMap.put(HB_ENV_KEY, HB_ENV_APP_VALUE);
        }
        if (StringUtils.isNotBlank((CharSequence)categoryDuration)) {
            keywordMap.put(HB_CATEGORY_DURATION_KEY, categoryDuration);
        }
        return keywordMap.asMap();
    }

    private boolean isPriceGranularityValid() {
        return this.priceGranularity != null;
    }

    private static String sizeFrom(Integer width, Integer height) {
        return width != null && width != 0 && height != null && height != 0 ? "%sx%s".formatted(width, height) : null;
    }

    private Map<String, String> truncateKeys(Map<String, String> keyValues) {
        return this.truncateAttrChars > 0 ? keyValues.entrySet().stream().collect(Collectors.toMap(keyValue -> this.truncateKey((String)keyValue.getKey()), Map.Entry::getValue, (key1, key2) -> key1)) : keyValues;
    }

    private String truncateKey(String key) {
        return key.length() > this.truncateAttrChars ? key.substring(0, this.truncateAttrChars) : key;
    }

    private static class KeywordMap {
        private final String bidder;
        private final boolean winningBid;
        private final boolean includeWinners;
        private final boolean includeBidderKeys;
        private final Set<String> excludedBidderKeys;
        private final Map<String, String> keywords;

        KeywordMap(String bidder, boolean winningBid, boolean includeWinners, boolean includeBidderKeys, Set<String> excludedBidderKeys) {
            this.bidder = bidder;
            this.winningBid = winningBid;
            this.includeWinners = includeWinners;
            this.includeBidderKeys = includeBidderKeys;
            this.excludedBidderKeys = excludedBidderKeys;
            this.keywords = new HashMap<String, String>();
        }

        void put(String prefix, String value) {
            this.createKeys(prefix).forEach(key -> this.keywords.put((String)key, value));
        }

        private List<String> createKeys(String prefix) {
            ArrayList<String> keys = new ArrayList<String>(2);
            if (this.includeBidderKeys && !this.excludedBidderKeys.contains(prefix)) {
                keys.add("%s_%s".formatted(prefix, this.bidder));
            }
            if (this.winningBid && this.includeWinners) {
                keys.add(prefix);
            }
            return keys;
        }

        private Map<String, String> asMap() {
            return this.keywords;
        }
    }
}

