/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.reporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import io.netty.channel.ConnectTimeoutException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.impl.ActivityInvocationPayloadImpl;
import org.prebid.server.activity.infrastructure.payload.impl.BidRequestActivityInvocationPayload;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.model.AmpEvent;
import org.prebid.server.analytics.model.AuctionEvent;
import org.prebid.server.analytics.model.CookieSyncEvent;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.model.SetuidEvent;
import org.prebid.server.analytics.model.VideoEvent;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.util.StreamUtil;

public class AnalyticsReporterDelegator {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsReporterDelegator.class);
    private static final ConditionalLogger UNKNOWN_ADAPTERS_LOGGER = new ConditionalLogger(logger);
    private static final Set<String> ADAPTERS_PERMITTED_FOR_FULL_DATA = Collections.singleton("logAnalytics");
    private final double logSamplingRate;
    private final List<AnalyticsReporter> delegates;
    private final Vertx vertx;
    private final PrivacyEnforcementService privacyEnforcementService;
    private final Metrics metrics;
    private final Set<Integer> reporterVendorIds;
    private final Set<String> reporterNames;

    public AnalyticsReporterDelegator(double logSamplingRate, List<AnalyticsReporter> delegates, Vertx vertx, PrivacyEnforcementService privacyEnforcementService, Metrics metrics) {
        this.logSamplingRate = logSamplingRate;
        this.delegates = Objects.requireNonNull(delegates);
        this.vertx = Objects.requireNonNull(vertx);
        this.privacyEnforcementService = Objects.requireNonNull(privacyEnforcementService);
        this.metrics = Objects.requireNonNull(metrics);
        this.reporterVendorIds = delegates.stream().map(AnalyticsReporter::vendorId).collect(Collectors.toSet());
        this.reporterNames = delegates.stream().map(AnalyticsReporter::name).collect(Collectors.toSet());
    }

    public <T> void processEvent(T event) {
        for (AnalyticsReporter analyticsReporter : this.delegates) {
            if (!AnalyticsReporterDelegator.isAllowedAdapter(event, analyticsReporter.name())) continue;
            this.vertx.runOnContext(ignored -> this.processEventByReporter(analyticsReporter, event));
        }
    }

    public <T> void processEvent(T event, TcfContext tcfContext) {
        this.privacyEnforcementService.resultForVendorIds(this.reporterVendorIds, tcfContext).onComplete(privacyEnforcementMap -> this.delegateEvent(event, tcfContext, (AsyncResult<Map<Integer, PrivacyEnforcementAction>>)privacyEnforcementMap));
    }

    private <T> void delegateEvent(T event, TcfContext tcfContext, AsyncResult<Map<Integer, PrivacyEnforcementAction>> privacyEnforcementMapResult) {
        if (privacyEnforcementMapResult.succeeded()) {
            Map privacyEnforcementActionMap = (Map)privacyEnforcementMapResult.result();
            this.checkUnknownAdaptersForAuctionEvent(event);
            for (AnalyticsReporter analyticsReporter : this.delegates) {
                String name = analyticsReporter.name();
                if (!AnalyticsReporterDelegator.isAllowedAdapter(event, name)) continue;
                Object updatedEvent = this.updateEvent(event, name);
                int reporterVendorId = analyticsReporter.vendorId();
                PrivacyEnforcementAction reporterPrivacyAction = privacyEnforcementActionMap.getOrDefault(reporterVendorId, PrivacyEnforcementAction.restrictAll());
                if (reporterPrivacyAction.isBlockAnalyticsReport()) continue;
                this.vertx.runOnContext(ignored -> this.processEventByReporter(analyticsReporter, updatedEvent));
            }
        } else {
            Throwable privacyEnforcementException = privacyEnforcementMapResult.cause();
            logger.error((Object)"Analytics TCF enforcement check failed for consentString: {0} and delegates with vendorIds {1}", privacyEnforcementException, new Object[]{tcfContext.getConsentString(), this.delegates});
        }
    }

    private <T> void checkUnknownAdaptersForAuctionEvent(T event) {
        if (event instanceof AuctionEvent) {
            this.logUnknownAdapters((AuctionEvent)event);
        }
    }

    private void logUnknownAdapters(AuctionEvent auctionEvent) {
        List<String> unknownAdapterNames;
        Iterator analyticsFieldNames;
        AuctionContext auctionContext = auctionEvent.getAuctionContext();
        BidRequest bidRequest = auctionContext != null ? auctionContext.getBidRequest() : null;
        ExtRequest extRequest = bidRequest != null ? bidRequest.getExt() : null;
        ExtRequestPrebid extPrebid = extRequest != null ? extRequest.getPrebid() : null;
        JsonNode analytics = extPrebid != null ? extPrebid.getAnalytics() : null;
        Iterator iterator = analyticsFieldNames = AnalyticsReporterDelegator.isNotEmptyObjectNode(analytics) ? analytics.fieldNames() : null;
        if (analyticsFieldNames != null && CollectionUtils.isNotEmpty(unknownAdapterNames = StreamUtil.asStream(analyticsFieldNames).filter(adapter -> !this.reporterNames.contains(adapter)).toList())) {
            Site site = bidRequest.getSite();
            String refererUrl = site != null ? site.getPage() : null;
            UNKNOWN_ADAPTERS_LOGGER.warn("Unknown adapters in ext.prebid.analytics[].adapter: %s, referrer: '%s'".formatted(unknownAdapterNames, refererUrl), this.logSamplingRate);
        }
    }

    private static boolean isNotEmptyObjectNode(JsonNode analytics) {
        return analytics != null && analytics.isObject() && !analytics.isEmpty();
    }

    private static <T> boolean isAllowedAdapter(T event, String adapter) {
        ActivityInvocationPayload activityInvocationPayload;
        ActivityInfrastructure activityInfrastructure;
        if (event instanceof AuctionEvent) {
            AuctionEvent auctionEvent = (AuctionEvent)event;
            AuctionContext auctionContext = auctionEvent.getAuctionContext();
            activityInfrastructure = auctionContext != null ? auctionContext.getActivityInfrastructure() : null;
            activityInvocationPayload = auctionContext != null ? BidRequestActivityInvocationPayload.of(AnalyticsReporterDelegator.activityInvocationPayload(adapter), auctionContext.getBidRequest()) : null;
        } else if (event instanceof AmpEvent) {
            AmpEvent ampEvent = (AmpEvent)event;
            AuctionContext auctionContext = ampEvent.getAuctionContext();
            activityInfrastructure = auctionContext != null ? auctionContext.getActivityInfrastructure() : null;
            activityInvocationPayload = auctionContext != null ? BidRequestActivityInvocationPayload.of(AnalyticsReporterDelegator.activityInvocationPayload(adapter), auctionContext.getBidRequest()) : null;
        } else if (event instanceof NotificationEvent) {
            NotificationEvent notificationEvent = (NotificationEvent)event;
            activityInfrastructure = notificationEvent.getActivityInfrastructure();
            activityInvocationPayload = AnalyticsReporterDelegator.activityInvocationPayload(adapter);
        } else {
            activityInfrastructure = null;
            activityInvocationPayload = null;
        }
        return AnalyticsReporterDelegator.isAllowedActivity(activityInfrastructure, Activity.REPORT_ANALYTICS, activityInvocationPayload);
    }

    private static ActivityInvocationPayload activityInvocationPayload(String adapterName) {
        return ActivityInvocationPayloadImpl.of(ComponentType.ANALYTICS, adapterName);
    }

    private <T> T updateEvent(T event, String adapter) {
        if (!ADAPTERS_PERMITTED_FOR_FULL_DATA.contains(adapter) && event instanceof AuctionEvent) {
            AuctionEvent auctionEvent = (AuctionEvent)event;
            AuctionContext updatedAuctionContext = this.updateAuctionContextAdapter(auctionEvent.getAuctionContext(), adapter);
            return (T)(updatedAuctionContext != null ? auctionEvent.toBuilder().auctionContext(updatedAuctionContext).build() : event);
        }
        return event;
    }

    private AuctionContext updateAuctionContextAdapter(AuctionContext context, String adapter) {
        ActivityInfrastructure activityInfrastructure;
        if (context == null) {
            return null;
        }
        BidRequest bidRequest = context.getBidRequest();
        BidRequest updatedBidRequest = this.updateBidRequest(bidRequest, adapter, activityInfrastructure = context.getActivityInfrastructure());
        return updatedBidRequest != null ? context.toBuilder().bidRequest(updatedBidRequest).build() : null;
    }

    private BidRequest updateBidRequest(BidRequest bidRequest, String adapter, ActivityInfrastructure infrastructure) {
        BidRequestActivityInvocationPayload activityInvocationPayload = BidRequestActivityInvocationPayload.of(AnalyticsReporterDelegator.activityInvocationPayload(adapter), bidRequest);
        boolean disallowTransmitUfpd = !AnalyticsReporterDelegator.isAllowedActivity(infrastructure, Activity.TRANSMIT_UFPD, activityInvocationPayload);
        boolean disallowTransmitGeo = !AnalyticsReporterDelegator.isAllowedActivity(infrastructure, Activity.TRANSMIT_GEO, activityInvocationPayload);
        User user = bidRequest != null ? bidRequest.getUser() : null;
        User resolvedUser = this.privacyEnforcementService.maskUserConsideringActivityRestrictions(user, disallowTransmitUfpd, disallowTransmitGeo);
        Device device = bidRequest != null ? bidRequest.getDevice() : null;
        Device resolvedDevice = this.privacyEnforcementService.maskDeviceConsideringActivityRestrictions(device, disallowTransmitUfpd, disallowTransmitGeo);
        ExtRequest requestExt = bidRequest != null ? bidRequest.getExt() : null;
        ExtRequest updatedExtRequest = AnalyticsReporterDelegator.updateExtRequest(requestExt, adapter);
        return resolvedUser != null || resolvedDevice != null || updatedExtRequest != null ? bidRequest.toBuilder().user(resolvedUser != null ? resolvedUser : user).device(resolvedDevice != null ? resolvedDevice : device).ext(updatedExtRequest != null ? updatedExtRequest : requestExt).build() : null;
    }

    private static boolean isAllowedActivity(ActivityInfrastructure activityInfrastructure, Activity activity, ActivityInvocationPayload activityInvocationPayload) {
        return activityInfrastructure != null ? activityInfrastructure.isAllowed(activity, activityInvocationPayload) : true;
    }

    private static ExtRequest updateExtRequest(ExtRequest requestExt, String adapterName) {
        ExtRequest updatedExtRequest;
        ExtRequestPrebid extPrebid = requestExt != null ? requestExt.getPrebid() : null;
        JsonNode analytics = extPrebid != null ? extPrebid.getAnalytics() : null;
        ObjectNode preparedAnalytics = AnalyticsReporterDelegator.isNotEmptyObjectNode(analytics) ? AnalyticsReporterDelegator.prepareAnalytics((ObjectNode)analytics, adapterName) : null;
        ExtRequest extRequest = updatedExtRequest = preparedAnalytics != null ? ExtRequest.of(extPrebid.toBuilder().analytics((JsonNode)preparedAnalytics).build()) : null;
        if (updatedExtRequest != null) {
            updatedExtRequest.addProperties(requestExt.getProperties());
        }
        return updatedExtRequest;
    }

    private static ObjectNode prepareAnalytics(ObjectNode analytics, String adapterName) {
        ObjectNode analyticsNodeCopy = analytics.deepCopy();
        JsonNode adapterNode = analyticsNodeCopy.get(adapterName);
        analyticsNodeCopy.removeAll();
        if (adapterNode != null) {
            analyticsNodeCopy.set(adapterName, adapterNode);
        }
        return !analyticsNodeCopy.isEmpty() ? analyticsNodeCopy : null;
    }

    private <T> void processEventByReporter(AnalyticsReporter analyticsReporter, T event) {
        String reporterName = analyticsReporter.name();
        analyticsReporter.processEvent(event).map(ignored -> this.processSuccess(event, reporterName)).otherwise(exception -> this.processFail((Throwable)exception, event, reporterName));
    }

    private <T> Future<Void> processSuccess(T event, String reporterName) {
        this.updateMetricsByEventType(event, reporterName, MetricName.ok);
        return Future.succeededFuture();
    }

    private <T> Future<Void> processFail(Throwable exception, T event, String reporterName) {
        MetricName failedResult = exception instanceof TimeoutException || exception instanceof ConnectTimeoutException ? MetricName.timeout : (exception instanceof InvalidRequestException ? MetricName.badinput : MetricName.err);
        this.updateMetricsByEventType(event, reporterName, failedResult);
        return Future.failedFuture((Throwable)exception);
    }

    private <T> void updateMetricsByEventType(T event, String analyticsCode, MetricName result) {
        MetricName eventType = event instanceof AmpEvent ? MetricName.event_amp : (event instanceof AuctionEvent ? MetricName.event_auction : (event instanceof CookieSyncEvent ? MetricName.event_cookie_sync : (event instanceof NotificationEvent ? MetricName.event_notification : (event instanceof SetuidEvent ? MetricName.event_setuid : (event instanceof VideoEvent ? MetricName.event_video : MetricName.event_unknown)))));
        this.metrics.updateAnalyticEventMetric(analyticsCode, eventType, result);
    }
}

