/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.prebid.server.proto.response.BidderUsersyncStatus;

public final class CookieSyncEvent {
    private final Integer status;
    private final List<String> errors;
    private final List<BidderUsersyncStatus> bidderStatus;

    public static CookieSyncEvent error(int status, String message) {
        return CookieSyncEvent.builder().status(status).errors(Collections.singletonList(message)).build();
    }

    @ConstructorProperties(value={"status", "errors", "bidderStatus"})
    CookieSyncEvent(Integer status, List<String> errors, List<BidderUsersyncStatus> bidderStatus) {
        this.status = status;
        this.errors = errors;
        this.bidderStatus = bidderStatus;
    }

    public static CookieSyncEventBuilder builder() {
        return new CookieSyncEventBuilder();
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<BidderUsersyncStatus> getBidderStatus() {
        return this.bidderStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieSyncEvent)) {
            return false;
        }
        CookieSyncEvent other = (CookieSyncEvent)o;
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<BidderUsersyncStatus> this$bidderStatus = this.getBidderStatus();
        List<BidderUsersyncStatus> other$bidderStatus = other.getBidderStatus();
        return !(this$bidderStatus == null ? other$bidderStatus != null : !((Object)this$bidderStatus).equals(other$bidderStatus));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<BidderUsersyncStatus> $bidderStatus = this.getBidderStatus();
        result = result * 59 + ($bidderStatus == null ? 43 : ((Object)$bidderStatus).hashCode());
        return result;
    }

    public String toString() {
        return "CookieSyncEvent(status=" + this.getStatus() + ", errors=" + this.getErrors() + ", bidderStatus=" + this.getBidderStatus() + ")";
    }

    public static class CookieSyncEventBuilder {
        private Integer status;
        private List<String> errors;
        private List<BidderUsersyncStatus> bidderStatus;

        CookieSyncEventBuilder() {
        }

        public CookieSyncEventBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public CookieSyncEventBuilder errors(List<String> errors) {
            this.errors = errors;
            return this;
        }

        public CookieSyncEventBuilder bidderStatus(List<BidderUsersyncStatus> bidderStatus) {
            this.bidderStatus = bidderStatus;
            return this;
        }

        public CookieSyncEvent build() {
            return new CookieSyncEvent(this.status, this.errors, this.bidderStatus);
        }

        public String toString() {
            return "CookieSyncEvent.CookieSyncEventBuilder(status=" + this.status + ", errors=" + this.errors + ", bidderStatus=" + this.bidderStatus + ")";
        }
    }
}

