/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.debug.USNatModuleLogEntry;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.Gpc;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.KnownChildSensitiveDataConsent;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.MspaServiceProviderMode;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.PersonalDataConsents;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.USNatField;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class USNatSyncUser
implements PrivacyModule,
Loggable {
    private final USNatGppReader gppReader;
    private final Rule.Result result;

    public USNatSyncUser(USNatGppReader gppReader) {
        this.gppReader = gppReader;
        this.result = USNatSyncUser.disallow(gppReader) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    public static boolean disallow(USNatGppReader gppReader) {
        return USNatSyncUser.equals(gppReader.getMspaServiceProviderMode(), MspaServiceProviderMode.YES) || USNatSyncUser.equals(gppReader.getGpc(), Gpc.TRUE) || USNatSyncUser.checkSale(gppReader) || USNatSyncUser.checkSharing(gppReader) || USNatSyncUser.checkTargetedAdvertising(gppReader) || USNatSyncUser.checkKnownChildSensitiveDataConsents(gppReader) || USNatSyncUser.equals(gppReader.getPersonalDataConsents(), PersonalDataConsents.CONSENT);
    }

    private static boolean checkSale(USNatGppReader gppReader) {
        Integer saleOptOut = gppReader.getSaleOptOut();
        Integer saleOptOutNotice = gppReader.getSaleOptOutNotice();
        return USNatSyncUser.equals(saleOptOut, SaleOptOut.OPTED_OUT) || USNatSyncUser.equals(saleOptOutNotice, SaleOptOutNotice.NO) || USNatSyncUser.equals(saleOptOutNotice, SaleOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals(saleOptOut, SaleOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkSharing(USNatGppReader gppReader) {
        Integer sharingNotice = gppReader.getSharingNotice();
        Integer sharingOptOut = gppReader.getSharingOptOut();
        Integer sharingOptOutNotice = gppReader.getSharingOptOutNotice();
        return USNatSyncUser.equals(sharingNotice, SharingNotice.NO) || USNatSyncUser.equals(sharingOptOut, SharingOptOut.OPTED_OUT) || USNatSyncUser.equals(sharingOptOutNotice, SharingOptOutNotice.NO) || USNatSyncUser.equals(sharingNotice, SharingNotice.NOT_APPLICABLE) && USNatSyncUser.equals(sharingOptOut, SharingOptOut.DID_NOT_OPT_OUT) || USNatSyncUser.equals(sharingOptOutNotice, SharingOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals(sharingOptOut, SharingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkTargetedAdvertising(USNatGppReader gppReader) {
        Integer targetedAdvertisingOptOut = gppReader.getTargetedAdvertisingOptOut();
        Integer targetedAdvertisingOptOutNotice = gppReader.getTargetedAdvertisingOptOutNotice();
        return USNatSyncUser.equals(targetedAdvertisingOptOut, TargetedAdvertisingOptOut.OPTED_OUT) || USNatSyncUser.equals(targetedAdvertisingOptOutNotice, TargetedAdvertisingOptOutNotice.NO) || USNatSyncUser.equals(targetedAdvertisingOptOutNotice, TargetedAdvertisingOptOutNotice.NOT_APPLICABLE) && USNatSyncUser.equals(targetedAdvertisingOptOut, TargetedAdvertisingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkKnownChildSensitiveDataConsents(USNatGppReader gppReader) {
        List<Integer> knownChildSensitiveDataConsents = gppReader.getKnownChildSensitiveDataConsents();
        return USNatSyncUser.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 0) || USNatSyncUser.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 1) || USNatSyncUser.equalsAtIndex(KnownChildSensitiveDataConsent.CONSENT, knownChildSensitiveDataConsents, 1);
    }

    private static <T> boolean equalsAtIndex(USNatField<T> expectedValue, List<T> list, int index) {
        return list != null && list.size() > index && USNatSyncUser.equals(list.get(index), expectedValue);
    }

    private static <T> boolean equals(T providedValue, USNatField<T> expectedValue) {
        return Objects.equals(providedValue, expectedValue.value());
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return USNatModuleLogEntry.from(this, this.gppReader, this.result);
    }
}

