/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.creator.ActivityControllerCreationContext;
import org.prebid.server.activity.infrastructure.creator.rule.AbstractRuleCreator;
import org.prebid.server.activity.infrastructure.rule.ComponentRule;
import org.prebid.server.activity.infrastructure.rule.Rule;
import org.prebid.server.settings.model.activity.rule.AccountActivityComponentRuleConfig;

public class ComponentRuleCreator
extends AbstractRuleCreator<AccountActivityComponentRuleConfig> {
    public ComponentRuleCreator() {
        super(AccountActivityComponentRuleConfig.class);
    }

    @Override
    protected Rule fromConfiguration(AccountActivityComponentRuleConfig ruleConfiguration, ActivityControllerCreationContext creationContext) {
        boolean allow = ComponentRuleCreator.allowFromConfig(ruleConfiguration.getAllow());
        AccountActivityComponentRuleConfig.Condition condition = ruleConfiguration.getCondition();
        return new ComponentRule(condition != null ? ComponentRuleCreator.setOf(condition.getComponentTypes()) : null, condition != null ? ComponentRuleCreator.caseInsensitiveSetOf(condition.getComponentNames()) : null, allow);
    }

    private static boolean allowFromConfig(Boolean configValue) {
        return configValue != null ? configValue : true;
    }

    private static Set<ComponentType> setOf(Collection<ComponentType> collection) {
        return collection != null ? new HashSet<ComponentType>(collection) : null;
    }

    private static Set<String> caseInsensitiveSetOf(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        TreeSet<String> caseInsensitiveSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveSet.addAll(collection);
        return caseInsensitiveSet;
    }
}

