/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator.privacy.usnat;

import com.iab.gpp.encoder.GppModel;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.infrastructure.creator.PrivacyModuleCreationContext;
import org.prebid.server.activity.infrastructure.creator.privacy.PrivacyModuleCreator;
import org.prebid.server.activity.infrastructure.creator.privacy.usnat.USNatGppReaderFactory;
import org.prebid.server.activity.infrastructure.privacy.AndPrivacyModules;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModuleQualifier;
import org.prebid.server.activity.infrastructure.privacy.PrivacySection;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatModule;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.settings.model.activity.privacy.AccountUSNatModuleConfig;

public class USNatModuleCreator
implements PrivacyModuleCreator {
    private static final Set<Integer> ALLOWED_SECTIONS_IDS = PrivacySection.US_PRIVACY_SECTIONS.stream().map(PrivacySection::sectionId).collect(Collectors.toSet());
    private final USNatGppReaderFactory gppReaderFactory;

    public USNatModuleCreator(USNatGppReaderFactory gppReaderFactory) {
        this.gppReaderFactory = Objects.requireNonNull(gppReaderFactory);
    }

    @Override
    public PrivacyModuleQualifier qualifier() {
        return PrivacyModuleQualifier.US_NAT;
    }

    @Override
    public PrivacyModule from(PrivacyModuleCreationContext creationContext) {
        AccountUSNatModuleConfig moduleConfig = USNatModuleCreator.moduleConfig(creationContext);
        GppContext.Scope scope = creationContext.getGppContext().scope();
        List<PrivacyModule> innerPrivacyModules = SetUtils.emptyIfNull(scope.getSectionsIds()).stream().filter(sectionId -> !USNatModuleCreator.shouldSkip(sectionId, moduleConfig)).map(sectionId -> this.forSection(creationContext.getActivity(), (Integer)sectionId, scope.getGppModel())).toList();
        return new AndPrivacyModules(innerPrivacyModules);
    }

    private static AccountUSNatModuleConfig moduleConfig(PrivacyModuleCreationContext creationContext) {
        return (AccountUSNatModuleConfig)creationContext.getPrivacyModuleConfig();
    }

    private static boolean shouldSkip(Integer sectionId, AccountUSNatModuleConfig moduleConfig) {
        AccountUSNatModuleConfig.Config config = moduleConfig.getConfig();
        List<Integer> skipSectionIds = config != null ? config.getSkipSids() : null;
        return !ALLOWED_SECTIONS_IDS.contains(sectionId) || skipSectionIds != null && skipSectionIds.contains(sectionId);
    }

    private PrivacyModule forSection(Activity activity, Integer sectionId, GppModel gppModel) {
        return new USNatModule(activity, this.gppReaderFactory.forSection(sectionId, gppModel));
    }
}

