/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.creator.privacy.uscustomlogic;

import com.iab.gpp.encoder.GppModel;
import org.prebid.server.activity.infrastructure.privacy.PrivacySection;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.USCustomLogicGppReader;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.reader.USCaliforniaGppReader;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.reader.USColoradoGppReader;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.reader.USConnecticutGppReader;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.reader.USUtahGppReader;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.reader.USVirginiaGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USMappedCaliforniaGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USMappedColoradoGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USMappedConnecticutGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USMappedUtahGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USMappedVirginiaGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.reader.USNationalGppReader;

public class USCustomLogicGppReaderFactory {
    public USCustomLogicGppReader forSection(int sectionId, boolean normalizeSection, GppModel gppModel) {
        PrivacySection privacySection = PrivacySection.from(sectionId);
        return !normalizeSection ? USCustomLogicGppReaderFactory.originalReader(privacySection, gppModel) : USCustomLogicGppReaderFactory.mappedReader(privacySection, gppModel);
    }

    private static USCustomLogicGppReader originalReader(PrivacySection privacySection, GppModel gppModel) {
        return switch (privacySection) {
            default -> throw new IncompatibleClassChangeError();
            case PrivacySection.NATIONAL -> new USNationalGppReader(gppModel);
            case PrivacySection.CALIFORNIA -> new USCaliforniaGppReader(gppModel);
            case PrivacySection.VIRGINIA -> new USVirginiaGppReader(gppModel);
            case PrivacySection.COLORADO -> new USColoradoGppReader(gppModel);
            case PrivacySection.UTAH -> new USUtahGppReader(gppModel);
            case PrivacySection.CONNECTICUT -> new USConnecticutGppReader(gppModel);
        };
    }

    private static USCustomLogicGppReader mappedReader(PrivacySection privacySection, GppModel gppModel) {
        return switch (privacySection) {
            default -> throw new IncompatibleClassChangeError();
            case PrivacySection.NATIONAL -> new USNationalGppReader(gppModel);
            case PrivacySection.CALIFORNIA -> new USMappedCaliforniaGppReader(gppModel);
            case PrivacySection.VIRGINIA -> new USMappedVirginiaGppReader(gppModel);
            case PrivacySection.COLORADO -> new USMappedColoradoGppReader(gppModel);
            case PrivacySection.UTAH -> new USMappedUtahGppReader(gppModel);
            case PrivacySection.CONNECTICUT -> new USMappedConnecticutGppReader(gppModel);
        };
    }
}

